drop view  w83bcomempresas;



CREATE OR REPLACE FUNCTION stragg(input VARCHAR2)

RETURN VARCHAR2

parallel_enable aggregate USING STRING_AGG_TYPE;

/

/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION stragg_int(input VARCHAR2)

RETURN VARCHAR2

parallel_enable aggregate USING string_agg_int;

/



/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION CONTARACTASREGDEF(fechaRegistro IN VARCHAR2, fechaEntrada IN VARCHAR2,territorio IN VARCHAR2, numRegistro IN NUMBER, annoRegistro IN NUMBER)

     RETURN tabla_numeroactasregdef

     IS

         v_tabla_numeroactasregdef tabla_numeroactasregdef := tabla_numeroactasregdef();

         versionVar NUMBER; 

         anoactaVar NUMBER; 

         territVar VARCHAR2(2);

         numRegDefVar NUMBER:=1;

         fechaEntradaVar DATE;

         numEntradaVar VARCHAR2(15);

         numActaVar NUMBER;

         cifVar VARCHAR2(10);

         numCentroVar NUMBER;

         razonSocialVar VARCHAR2(50);

         direccionVar VARCHAR2(50);

         numTrabajadoresVar NUMBER;

         numRepresentantesVar NUMBER;

         nactacompletovar VARCHAR2(15);

         prov VARCHAR2(2);

         mun VARCHAR2(3); 

         seccionVar VARCHAR2(2);

         contador NUMBER:=1;

         lau VARCHAR2(1);

         fdeses DATE;

         nimpug NUMBER; 

         numeroacta NUMBER:=0;

         impugcorrecta VARCHAR2(4):='ok';

         contadorf NUMBER:=0;

         territ VARCHAR2(2):='00';

         anoacta NUMBER:=0;

         ver NUMBER:=0;

         numeroactas NUMBER:=0;

         CURSOR actasConsultar IS

            SELECT   consulta.ver, consulta.anoacta, consulta.territ, consulta.nacta, consulta.fechaentrada, 

            consulta.numreg, consulta.cif, consulta.numcentro, consulta.razon,

            consulta.domicilio, consulta.numelectores,

            consulta.numrepresentantes, consulta.nactaintcompleto, consulta.nimpug, consulta.fdeses, consulta.lau, consulta.provincia, consulta.municipio, consulta.seccion

       FROM (SELECT actas.version_016 AS ver,

            actas.ano_acta_016 AS anoacta,

            actas.c_territ_016 AS territ,

            actas.n_acta_016 AS nacta, 

            actas.f_entra_016 AS fechaentrada, 

               actas.c_territ_016 || '/' 

                || actas.ano_acta_016 || '/' 

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

                AS numreg,

            centros.ccif_001 AS cif,

            centros.ncen_001 AS numcentro,

            centros.rsoc_001 AS razon, 

            centros.domic_001 AS domicilio, 

            actas.totelec_016 AS numelectores, 

            impugnaciones.fdeses_033 AS fdeses,

            impugnaciones.n_impug_033 AS nimpug,

            laudos.rdo_laudo_068 AS lau,

            centros.provc_001 AS provincia,

            centros.munic_001 AS municipio,

            centros.secc_001 AS seccion,

            COUNT(delegados.dni_025) AS numrepresentantes,

            TO_NUMBER

               (   actas.c_territ_016

                || actas.ano_acta_016

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

               ) AS nactaintcompleto

       FROM w83b33s00 impugnaciones,

            w83b16s00 actas,

            w83b25s00 delegados,

            w83b68s00 laudos,

            j7301s01 centros

      WHERE impugnaciones.n_acta_033(+) = actas.n_acta_016

        AND impugnaciones.ano_acta_033(+) = actas.ano_acta_016

        AND impugnaciones.c_territ_033(+) = actas.c_territ_016

        AND impugnaciones.version_033(+) = actas.version_016

        AND actas.n_acta_016 = delegados.n_acta_025(+)

        AND actas.ano_acta_016 = delegados.ano_acta_025(+)

        AND actas.c_territ_016 = delegados.c_territ_025(+)

        AND actas.version_016 = delegados.version_025(+)

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND actas.id_centro_016 = centros.ccen_001

        AND actas.f_baja_016 IS NULL

        AND actas.fregdef_016 IS NULL

        AND actas.n_regdef_016 IS NULL

        --AND (actas.f_reque_016 IS NULL OR (actas.f_reque_016 IS NOT NULL AND actas.f_subreq_016 IS NOT NULL))

        AND actas.n_preaviso_016 IS NOT NULL

        --AND (   actas.s_comi_016 = 'N'

             --OR actas.s_comi_016 IS NULL

             --OR (actas.s_comi_016 = 'S' AND actas.f_comis_016 IS NOT NULL)

            --)

        AND ACTAS.F_ENTRA_016<=TO_DATE(fechaEntrada,'dd/MM/yyyy') 

        AND ACTAS.C_TERRIT_016=territorio 

        AND delegados.cbaja_025 IS NULL

       GROUP BY

        actas.version_016,actas.ano_acta_016,

            actas.c_territ_016,actas.n_acta_016, actas.f_entra_016, actas.n_reg_016,

            centros.ccif_001, centros.ncen_001,

            centros.rsoc_001, centros.domic_001, 

            actas.totelec_016, impugnaciones.fdeses_033, impugnaciones.n_impug_033,laudos.rdo_laudo_068,

            centros.provc_001,centros.munic_001,centros.secc_001,

              TO_NUMBER

               (   actas.c_territ_016

                || actas.ano_acta_016

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

               )) consulta

            WHERE consulta.ver =

               (SELECT MAX (version_016)

                  FROM w83b16s00 act

                 WHERE consulta.nacta = act.n_acta_016

                   AND consulta.anoacta = act.ano_acta_016

                   AND consulta.territ = c_territ_016)

        ORDER BY consulta.fechaentrada,consulta.nactaintcompleto ;                    

   BEGIN

       OPEN actasConsultar; 

       LOOP

            FETCH actasConsultar INTO versionVar, anoactaVar, territVar, numActaVar,fechaEntradaVar,numEntradaVar,cifVar,numCentroVar,razonSocialVar,direccionVar,numTrabajadoresVar,numRepresentantesVar,nactacompletoVar, nimpug, fdeses, lau,prov,mun,seccionVar;

            EXIT WHEN actasConsultar%NOTFOUND;

            IF (numeroacta!=numActaVar OR territ!=territVar OR anoacta!=anoactaVar OR ver!=versionVar) THEN

                IF (impugcorrecta='ok') THEN

                    IF (contadorf!=0) THEN

                        numeroactas:=numeroactas+1;

                    END IF;

                END IF;

                impugcorrecta:='ok';

                IF (nimpug IS NOT NULL) THEN

                    IF (lau IS NULL OR lau=1 OR fdeses IS NOT NULL) THEN

                        impugcorrecta:='nook';

                    END IF;

                END IF;

            ELSE

               IF (nimpug IS NOT NULL) THEN

                    IF (lau IS NULL OR lau=1 OR fdeses IS NOT NULL) THEN

                        impugcorrecta:='nook';

                    END IF;

                END IF; 

            END IF;

            contadorf:=contadorf+1;

            numeroacta:=numActaVar;

            territ:=territVar;

            anoacta:=anoactaVar;

            ver:=versionVar;

        END LOOP;

         

                IF (impugcorrecta='ok') THEN

                    IF (contadorf!=0) THEN

                        numeroactas:=numeroactas+1;

                    END IF;

                END IF;

        v_tabla_numeroactasregdef.EXTEND;

        v_tabla_numeroactasregdef(contador) := numeroactasregdef(numeroactas);    

        CLOSE actasConsultar;

   RETURN v_tabla_numeroactasregdef;

   

END CONTARACTASREGDEF; 

/

/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION DETALLEACTADATOSC

(num_acta IN NUMBER,ANO_ACTA IN NUMBER,territorio IN VARCHAR, VER IN NUMBER)

     RETURN tabla_detalleActaCompleto

     IS

         v_tabla_detalleActaCompleto tabla_detalleActaCompleto := tabla_detalleActaCompleto();

         versionVar NUMBER(2);

         anoactaVar NUMBER(4);

         num_actaVar NUMBER(6);

         territVar VARCHAR2(2);

         num_preavisoVar NUMBER(6);

         ano_preavisoVar NUMBER(4);

         codConvenioVar NUMBER(4);

         descConvenioVar VARCHAR2(250);

         deseConvenioVar VARCHAR2(250);

         descBajaVar VARCHAR2(250);

         deseBajaVar VARCHAR2(250);

         codBajaVar NUMBER(2);

         fehaEntradaVar Date;

         fehaEleccionVar Date;

         fehaRegistroVar Date;

         fehaRegistroDefVar Date;

         fehaComisionVar Date;

         fehaRequerimientoVar Date;

         fehaSubsanacionVar Date;

         fehaRetiradaVar Date;

         fehaPRRIVar Date;

         fehaBajaVar Date;

         fehaActualizacionVar Date;

         totalElectoresVar NUMBER(6);

         candidatosHombresVar NUMBER(6);

         candidatosMujeresVar NUMBER(6);

         anoActaTotalVar NUMBER(4);

         numActaTotalVar NUMBER(6);

         numRegistroVar VARCHAR2(15);

         anoRegistroDefVar NUMBER(4);

         numRegistroDefVar VARCHAR2(20);

         electoresHombresVar NUMBER(6);

         electoresMujeresVar NUMBER(6);

         comisionVar VARCHAR2(1);

         observacionesVar VARCHAR2(500);

         usuarioVar VARCHAR2(15);

         inspeccionadaVar NUMBER(1);

         fechaConstitucionVar Date;

         validadaVar VARCHAR2(1);

         remiteVar VARCHAR2(150);

         cifCentroVar VARCHAR2(10);

         numCentroVar NUMBER(3);



         posicionVar VARCHAR2(10);

         domicilioVar VARCHAR2(50);

         provinciaVar VARCHAR2(50);

         municipioVar VARCHAR2(50);

         codMunicipioVar VARCHAR2(3);

         codProvinciaVar VARCHAR2(2);

         razonSocialVar VARCHAR2(50);

         localidadVar varchar2(30);

         maxDelegadosVar NUMBER(5);



         delegadosVar NUMBER(6);

         delegadoshVar NUMBER(5);

         delegadosmVar NUMBER(5);

         totalEscrVar NUMBER(6);

         totalDifVar NUMBER(6);

         escrHombres0Var NUMBER(6);

         escrHombres1Var NUMBER(6);

         escrMujeres0Var NUMBER(6);

         escrMujeres1Var NUMBER(6);

         difHombres0Var NUMBER(6);

         difHombres1Var NUMBER(6);

         difMujeres0Var NUMBER(6);

         difMujeres1Var NUMBER(6);

         codCentroVar NUMBER(6);



         contador NUMBER(1):=1;

         contadorf NUMBER(1):=0;



         CURSOR actasConsultar IS

           SELECT   consulta.verss , consulta.anoacta, consulta.nacta,  consulta.territ, consulta.numpre,

            consulta.anopre, consulta.codcon, consulta.desccon, consulta.desecon,

            consulta.descbaja, consulta.desebaja,consulta.codbaja,

             consulta.fentr, consulta.fele, consulta.freg, consulta.fregdef, consulta.fcom,

            consulta.freq, consulta.fsub, consulta.fret, consulta.fprri, consulta.fbaja, consulta.factu,

            consulta.telec,

            consulta.hcand, consulta.mcand, consulta.anoactat, consulta.nactat, consulta.nreg, consulta.anoregdef, consulta.nregdef,

            consulta.helec, consulta.melec, consulta.comi, consulta.obser, consulta.usu, consulta.ins,consulta.fcons,

            consulta.valid,consulta.remite,consulta.ccif,consulta.ncentro,

            consulta.posi,consulta.domi,

            consulta.provincia,

            consulta.municipio,

            consulta.codMun, 

            consulta.codprov,

            consulta.razon, consulta.locali,

            consulta.maxdel,

            consulta.totdel,consulta.delh,consulta.delm,

            consulta.totalEscr,consulta.totalDif,

            consulta.escrHombres0,consulta.escrHombres1,

            consulta.escrMujeres0,consulta.escrMujeres1,

            consulta.difHombres0,consulta.difHombres1,

            consulta.difMujeres0,consulta.difMujeres1,consulta.idCentro



       FROM (SELECT version_016 verss, n_acta_016 nacta, ano_acta_016 anoacta , c_territ_016 territ, n_preaviso_016 numpre,

           ano_preaviso_016 anopre, c_conv_016 codcon, desc_013 desccon, dese_013 desecon,

           desc_017 descbaja,dese_017 desebaja, id_centro_016 idcentro, cbaja_016 codbaja,

           f_entra_016 fentr,f_elecc_016 fele,freglib_016 freg,

           fregdef_016 fregdef,f_comis_016 fcom,

           f_reque_016 freq,f_subreq_016 fsub,f_retcom_016 fret,

           f_prri_016 fprri, f_baja_016 fbaja,

           factu_016 factu,

           totelec_016 telec,candh_016 hcand, candm_016 mcand,

           ano_acttot_016 anoactat, n_acttot_016 nactat, n_reg_016 nreg, ano_regdef_016 anoregdef, 

           (   c_territ_016

                     || '/'

                     || ano_regdef_016

                     || '/'

                     || DECODE (LENGTH (TO_CHAR (n_regdef_016)),

                                1, '00000' || TO_CHAR (n_regdef_016),

                                2, '0000' || TO_CHAR (n_regdef_016),

                                3, '000' || TO_CHAR (n_regdef_016),

                                4, '00' || TO_CHAR (n_regdef_016),

                                5, '0' || TO_CHAR (n_regdef_016),

                                TO_CHAR (n_regdef_016)

                               )

                    ) nregdef,

           elech_016 helec, elecm_016 melec, s_comi_016 comi, observ_016 obser, usua_016 usu, inspec_016 ins,

           f_constcom_016 fcons,

           validada_016 valid,remite_016 remite, ccif_001 ccif, ncen_001 ncentro, cposc_001 posi, domic_001 domi,

           prov.ds_o  provincia, mun.ds_o  municipio,mun.ID codMun,

           TO_CHAR(DECODE (LENGTH (TO_CHAR (provc_001)),1,'0'||TO_CHAR (provc_001),TO_CHAR (provc_001))) codprov

           , rsoc_001 razon,

           local_001 locali,

           maxdel_016 maxdel,

           totdel_016 totdel,delh_016 delh,delm_016 delm,

           

       (SUM (n_delh_024) + SUM (n_delm_024)) AS totalEscr,--delegados de escrutinio

       (SUM (n_delh_018) + SUM (n_delm_018)) AS totalDif,--delegados de diferencia

       (SELECT SUM (n_delh_024)

          FROM W83B24T00

         WHERE n_acta_024 = num_acta

           AND ano_acta_024 = ANO_ACTA

           AND c_territ_024 = territorio

           AND version_024 = ver

           AND c_coleg_024 = '0') AS escrHombres0,--hombres del colegio 0

       (SELECT SUM (n_delm_024)

          FROM W83B24T00

         WHERE n_acta_024 = num_acta

           AND ano_acta_024 = ANO_ACTA

           AND c_territ_024 = territorio

           AND version_024 = ver

           AND c_coleg_024 = '0') AS escrmujeres0,--mujeres del colegio 0(delegados col0=escrHombres0+escrMujeres0)

       (SELECT SUM (n_delh_024)

          FROM W83B24T00

         WHERE n_acta_024 = num_acta

           AND ano_acta_024 = ANO_ACTA

           AND c_territ_024 = territorio

           AND version_024 = ver

           AND c_coleg_024 = '1') AS escrHombres1,--hombres del colegio 1

        (SELECT SUM (n_delm_024)

          FROM W83B24T00

         WHERE n_acta_024 = num_acta

           AND ano_acta_024 = ANO_ACTA

           AND c_territ_024 = territorio

           AND version_024 = ver

           AND c_coleg_024 = '1') AS escrMujeres1,--mujeres del colegio 1

       (SELECT SUM (n_delh_018)

          FROM W83B18T00

         WHERE n_acta_018 = num_acta

           AND ano_acta_018= ANO_ACTA

           AND c_territ_018 = territorio

           AND version_018 = ver

           AND c_coleg_018 = '0') AS difHombres0,--hombres del colegio 0 dif

       (SELECT SUM (n_delm_018)

          FROM W83B18T00

         WHERE n_acta_018 = num_acta

           AND ano_acta_018 = ANO_ACTA

           AND c_territ_018 = territorio

           AND version_018 = ver

           AND c_coleg_018 = '0') AS difmujeres0,--mujeres del colegio 0(delegados col0=difHombres0+difMujeres0)

       (SELECT SUM (n_delh_018)

          FROM W83B18T00

         WHERE n_acta_018 = num_acta

           AND ano_acta_018 = ANO_ACTA

           AND c_territ_018 = territorio

           AND version_018 = ver

           AND c_coleg_018 = '1') AS difHombres1,--hombres del colegio 1

       (SELECT SUM (n_delm_018)

          FROM W83B18T00

         WHERE n_acta_018 = num_acta

           AND ano_acta_018 = ANO_ACTA

           AND c_territ_018 = territorio

           AND version_018 = ver

           AND c_coleg_018 = '1') AS difMujeres1--mujeres del colegio 1

       FROM w83b16s00 acta,j7301s01 cen,

           w83b13s00 conv,W83B17T00 baja,t17i.t17_provincia prov,t17i.t17_municipio mun,

           W83B24T00 escr,W83B18T00 dif--,W83B25T00 del

      WHERE acta.id_centro_016 = cen.ccen_001(+)

           AND acta.c_conv_016 = conv.c_conv_013

           AND acta.cbaja_016 = baja.cbaja_017(+)

           AND acta.ANO_ACTA_016=escr.ANO_ACTA_024(+)

           AND acta.N_ACTA_016=escr.N_ACTA_024(+)

           AND acta.C_TERRIT_016=escr.C_TERRIT_024(+)

           AND acta.VERSION_016=escr.VERSION_024(+)

           AND acta.ANO_ACTA_016=dif.ANO_ACTA_018(+)

           AND acta.N_ACTA_016=dif.N_ACTA_018(+)

           AND acta.C_TERRIT_016=dif.C_TERRIT_018(+)

           AND acta.VERSION_016=dif.VERSION_018(+)

           AND cen.provc_001 = prov.ID(+)

           AND cen.munic_001 = mun.ID(+)

           AND prov.ID = mun.provincia_id

       GROUP BY  version_016, n_acta_016, ano_acta_016, c_territ_016, n_preaviso_016,

       ano_preaviso_016, c_conv_016, desc_013,dese_013,

       desc_017,dese_017, id_centro_016, cbaja_016,

       f_entra_016,

       f_elecc_016,

       freglib_016,

       fregdef_016,

       f_comis_016,

       f_reque_016,

       f_subreq_016,

       f_retcom_016,

       f_prri_016, f_baja_016,

       factu_016, totelec_016,

       candh_016 ,candm_016, candh_016, candm_016,

       ano_acttot_016, n_acttot_016, n_reg_016, ano_regdef_016, n_regdef_016,

       elech_016, elecm_016, s_comi_016, observ_016, usua_016, inspec_016,

       f_constcom_016, validada_016,remite_016, ccif_001, ncen_001, cposc_001, domic_001,

       prov.ds_o, mun.ds_o, mun.ID,provc_001, rsoc_001,

       local_001,

       maxdel_016,

       totdel_016,delh_016,delm_016



         ) consulta

            WHERE consulta.verss = ver

            AND consulta.nacta=num_acta

            AND consulta.anoacta=ANO_ACTA

            AND consulta.territ=territorio

   GROUP BY   consulta.verss , consulta.anoacta, consulta.nacta,  consulta.territ, consulta.numpre,

            consulta.anopre, consulta.codcon, consulta.desccon, consulta.desecon,

            consulta.descbaja, consulta.desebaja,consulta.codbaja,

             consulta.fentr, consulta.fele, consulta.freg, consulta.fregdef, consulta.fcom,

            consulta.freq, consulta.fsub, consulta.fret, consulta.fprri, consulta.fbaja, consulta.factu,

            consulta.telec,

            consulta.hcand, consulta.mcand, consulta.anoactat, consulta.nactat, consulta.nreg, consulta.anoregdef, consulta.nregdef,

            consulta.helec, consulta.melec, consulta.comi, consulta.obser, consulta.usu, consulta.ins,consulta.fcons,

            consulta.valid,consulta.remite, consulta.ccif,consulta.ncentro,consulta.provincia,

            consulta.municipio, consulta.posi,consulta.domi,

            consulta.codMun,consulta.codprov,

            consulta.razon, consulta.locali,

            consulta.maxdel,

            consulta.totdel,consulta.delh,consulta.delm,

            consulta.totalEscr,consulta.totalDif,

            consulta.escrHombres0,consulta.escrHombres1,

            consulta.escrMujeres0,consulta.escrMujeres1,

            consulta.difHombres0,consulta.difHombres1,

            consulta.difMujeres0,consulta.difMujeres1,idCentro;

   BEGIN

       OPEN actasConsultar;

       LOOP

            FETCH actasConsultar INTO versionVar, anoactaVar,num_actaVar, territVar,num_preavisoVar,

            ano_preavisoVar, codConvenioVar,

            descConvenioVar,deseConvenioVar,descBajaVar,deseBajaVar,codBajaVar,fehaEntradaVar,fehaEleccionVar,fehaRegistroVar,fehaRegistroDefVar,fehaComisionVar,fehaRequerimientoVar,fehaSubsanacionVar,

            fehaRetiradaVar,fehaPRRIVar,fehaBajaVar,fehaActualizacionVar,

            totalElectoresVar,candidatosHombresVar,candidatosMujeresVar,

            anoActaTotalVar,numActaTotalVar,numRegistroVar,anoRegistroDefVar,numRegistroDefVar,electoresHombresVar,electoresMujeresVar,

            comisionVar,observacionesVar,usuarioVar,inspeccionadaVar,fechaConstitucionVar,

            validadaVar,remiteVar,cifCentroVar,numCentroVar,

            posicionVar,domicilioVar,provinciaVar,municipioVar,

            codMunicipioVar,codProvinciaVar,

            razonSocialVar,localidadVar,

            maxDelegadosVar,



            delegadosVar,delegadoshVar,delegadosmVar,

            totalEscrVar,totalDifVar,

            escrHombres0Var,escrHombres1Var,escrMujeres0Var,escrMujeres1Var,

            difHombres0Var,difHombres1Var,difMujeres0Var,difMujeres1Var,codCentroVar;



            EXIT WHEN actasConsultar%NOTFOUND;





                        v_tabla_detalleActaCompleto.EXTEND;

                        v_tabla_detalleActaCompleto(contador) := detalleActaDatos(

                        versionVar ,anoactaVar,num_actaVar,territVar,num_preavisoVar,

                        ano_preavisoVar,codConvenioVar,descConvenioVar,deseConvenioVar,descBajaVar,

                        deseBajaVar,codBajaVar,fehaEntradaVar,fehaEleccionVar,fehaRegistroVar,

                        fehaRegistroDefVar,fehaComisionVar,fehaRequerimientoVar,fehaSubsanacionVar,fehaRetiradaVar,

                        fehaPRRIVar,fehaBajaVar,fehaActualizacionVar,

                        totalElectoresVar,candidatosHombresVar,

                        candidatosMujeresVar,anoActaTotalVar,numActaTotalVar,numRegistroVar,anoRegistroDefVar,

                        numRegistroDefVar,electoresHombresVar,electoresMujeresVar,comisionVar,observacionesVar,

                        usuarioVar,inspeccionadaVar,fechaConstitucionVar,

                        validadaVar,remiteVar,cifCentroVar,

                        numCentroVar,posicionVar,domicilioVar,provinciaVar,municipioVar,

                        codMunicipioVar,codProvinciaVar,

                        razonSocialVar,localidadVar,

                        maxDelegadosVar,

                        delegadosVar,delegadoshVar,delegadosmVar,

                        totalEscrVar,totalDifVar,

                        escrHombres0Var,escrHombres1Var,escrMujeres0Var,escrMujeres1Var,

                        difHombres0Var,difHombres1Var,difMujeres0Var,difMujeres1Var,codCentroVar

                        );

                        contador:=contador+1;



        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_detalleActaCompleto;



END DETALLEACTADATOSC;

/





/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION REGDEF(fechaRegistro IN VARCHAR2, fechaEntrada IN VARCHAR2,territorio IN VARCHAR2, numRegistro IN NUMBER, annoRegistro IN NUMBER)

     RETURN tabla_detalleActa

     IS

         v_tabla_detalleActa tabla_detalleActa := tabla_detalleActa();

         versionVar number; 

         anoactaVar number; 

         territVar varchar2(2);

         numRegDefVar number:=1;

         fechaEntradaVar DATE;

         numEntradaVar varchar2(15);

         numActaVar number;

         cifVar varchar2(10);

         numCentroVar number;

         razonSocialVar varchar2(50);

         direccionVar varchar2(50);

         numTrabajadoresVar number;

         numRepresentantesVar number;

         contador number:=1;

         lau varchar2(1);

         fdeses DATE;

         nimpug number; 

         numeroacta number:=0;

         impugcorrecta varchar2(4):='ok';

         contadorf number:=0;

         nactacompletovar varchar2(15);

         territ varchar2(2):='00';

         anoacta number:=0;

         ver number:=0;

         numRegDef number;

         fe DATE;

         numEntrada varchar2(15);

         cif varchar2(10);

         numCentro number;

         razonSocial varchar2(50);

         direccion varchar2(50);

         numTrabajadores number;

         numRepresentantes number;

         nactacompleto varchar2(15);

         provincia varchar2(2);

         municipio varchar2(3);

         prov varchar2(2);

         mun varchar2(3); 

         seccionVar varchar2(2);

         seccion varchar2(2);

         CURSOR actasConsultar IS

            SELECT   consulta.ver, consulta.anoacta, consulta.territ, consulta.nacta, consulta.fechaentrada, 

            consulta.numreg, consulta.cif, consulta.numcentro, consulta.razon,

            consulta.domicilio, consulta.numelectores,

            consulta.numrepresentantes, consulta.nactaintcompleto, consulta.nimpug, consulta.fdeses, consulta.lau, consulta.provincia, consulta.municipio, consulta.seccion

       FROM (SELECT actas.version_016 as ver,

            actas.ano_acta_016 as anoacta,

            actas.c_territ_016 as territ,

            actas.n_acta_016 as nacta, 

            actas.f_entra_016 as fechaentrada, 

               actas.c_territ_016 || '/' 

                || actas.ano_acta_016 || '/' 

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

                as numreg,

            centros.ccif_001 as cif,

            centros.ncen_001 as numcentro,

            centros.rsoc_001 as razon, 

            centros.domic_001 as domicilio, 

            actas.totelec_016 as numelectores, 

            impugnaciones.fdeses_033 as fdeses,

            impugnaciones.n_impug_033 as nimpug,

            laudos.rdo_laudo_068 as lau,

            centros.provc_001 as provincia,

            centros.munic_001 as municipio,

            centros.secc_001 as seccion,

            count(delegados.dni_025) as numrepresentantes,

            TO_NUMBER

               (   actas.c_territ_016

                || actas.ano_acta_016

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

               ) AS nactaintcompleto

       FROM w83b33s00 impugnaciones,

            w83b16s00 actas,

            w83b25s00 delegados,

            w83b68s00 laudos,

            j7301s01 centros

      WHERE impugnaciones.n_acta_033(+) = actas.n_acta_016

        AND impugnaciones.ano_acta_033(+) = actas.ano_acta_016

        AND impugnaciones.c_territ_033(+) = actas.c_territ_016

        AND impugnaciones.version_033(+) = actas.version_016

        AND actas.n_acta_016 = delegados.n_acta_025(+)

        AND actas.ano_acta_016 = delegados.ano_acta_025(+)

        AND actas.c_territ_016 = delegados.c_territ_025(+)

        AND actas.version_016 = delegados.version_025(+)

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND actas.id_centro_016 = centros.ccen_001

        AND actas.f_baja_016 IS NULL

        AND actas.fregdef_016 IS NULL

        AND actas.n_regdef_016 IS NULL

        --AND (actas.f_reque_016 IS NULL OR (actas.f_reque_016 IS NOT NULL AND actas.f_subreq_016 IS NOT NULL))

        AND actas.n_preaviso_016 IS NOT NULL

        --AND (   actas.s_comi_016 = 'N'

             --OR actas.s_comi_016 IS NULL

             --OR (actas.s_comi_016 = 'S' AND actas.f_comis_016 IS NOT NULL)

            --)

        AND ACTAS.F_ENTRA_016<=TO_DATE(fechaEntrada,'dd/MM/yyyy') 

        AND ACTAS.C_TERRIT_016=territorio 

        AND delegados.cbaja_025 IS NULL

       GROUP BY

        actas.version_016,actas.ano_acta_016,

            actas.c_territ_016,actas.n_acta_016, actas.f_entra_016, actas.n_reg_016,

            centros.ccif_001, centros.ncen_001,

            centros.rsoc_001, centros.domic_001, 

            actas.totelec_016, impugnaciones.fdeses_033, impugnaciones.n_impug_033,laudos.rdo_laudo_068,

            centros.provc_001,centros.munic_001,centros.secc_001,

              TO_NUMBER

               (   actas.c_territ_016

                || actas.ano_acta_016

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

               )) consulta

            WHERE consulta.ver =

               (SELECT MAX (version_016)

                  FROM w83b16s00 act

                 WHERE consulta.nacta = act.n_acta_016

                   AND consulta.anoacta = act.ano_acta_016

                   AND consulta.territ = c_territ_016)

        ORDER BY consulta.fechaentrada,consulta.nactaintcompleto ;                     

   BEGIN

       OPEN actasConsultar; 

       LOOP

            FETCH actasConsultar INTO versionVar, anoactaVar, territVar, numActaVar,fechaEntradaVar,numEntradaVar,cifVar,numCentroVar,razonSocialVar,direccionVar,numTrabajadoresVar,numRepresentantesVar,nactacompletoVar, nimpug, fdeses, lau,prov,mun,seccionVar;

            EXIT WHEN actasConsultar%NOTFOUND;

            IF (numeroacta!=numActaVar OR territ!=territVar OR anoacta!=anoactaVar OR ver!=versionVar) THEN

                IF (impugcorrecta='ok') THEN

                    IF (contadorf!=0) THEN

                        v_tabla_detalleActa.EXTEND;

                        v_tabla_detalleActa(contador) := detalleActa(numRegDef,

                        fe,

                        numEntrada,

                        numeroacta,

                        cif,

                        numCentro,

                        razonSocial,

                        direccion,

                        numTrabajadores,

                        numRepresentantes,territ,anoacta,nactacompleto,provincia,municipio,seccion,ver);

                        contador:=contador+1;

                    END IF;

                END IF;

                impugcorrecta:='ok';

                IF (nimpug IS NOT NULL) THEN

                    IF (lau IS NULL OR lau=1 OR fdeses IS NOT NULL) THEN

                        impugcorrecta:='nook';

                    END IF;

                END IF;

            ELSE

               IF (nimpug IS NOT NULL) THEN

                    IF (lau IS NULL OR lau=1 OR fdeses IS NOT NULL) THEN

                        impugcorrecta:='nook';

                    END IF;

                END IF; 

            END IF;

            contadorf:=contadorf+1;

            numeroacta:=numActaVar;

            territ:=territVar;

            anoacta:=anoactaVar;

            ver:=versionVar;

            numRegDef:=numRegDefVar;

            fe:=fechaEntradaVar;

            numEntrada:=numEntradaVar;

            cif:=cifVar;

            numCentro:=numCentroVar;

            razonSocial:=razonSocialVar;

            direccion:=direccionVar;

            numTrabajadores:=numTrabajadoresVar;

            numRepresentantes:=numRepresentantesVar;

            nactacompleto:=nactacompletoVar;

            provincia:=prov;

            municipio:=mun;

            seccion:=seccionVar;

        END LOOP;

         

                IF (impugcorrecta='ok') THEN

                    IF (contadorf!=0) THEN

                        v_tabla_detalleActa.EXTEND;

                        v_tabla_detalleActa(contador) := detalleActa(numRegDef,

                        fe,

                        numEntrada,

                        numeroacta,

                        cif,

                        numCentro,

                        razonSocial,

                        direccion,

                        numTrabajadores,

                        numRepresentantes,territ,anoacta,nactacompleto,provincia,municipio,seccion,ver);

                        contador:=contador+1;

                    END IF;

                END IF;

            

        CLOSE actasConsultar;

   RETURN v_tabla_detalleActa;

   

END REGDEF;

/





/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION REGDEFMOD(fechaRegistro IN VARCHAR2, fechaEntrada IN VARCHAR2,territorio IN VARCHAR2, numRegistro IN NUMBER, annoRegistro IN NUMBER)

     RETURN tabla_detalleActa

     IS

         PRAGMA AUTONOMOUS_TRANSACTION;

         v_tabla_detalleActa tabla_detalleActa := tabla_detalleActa();

         versionVar number; 

         anoactaVar number; 

         territVar varchar2(2);

         numRegDefVar number:=1;

         fechaEntradaVar DATE;

         numEntradaVar varchar2(15);

         numActaVar number;

         cifVar varchar2(10);

         numCentroVar number;

         razonSocialVar varchar2(50);

         direccionVar varchar2(50);

         numTrabajadoresVar number;

         numRepresentantesVar number;

         contador number:=1;

         lau varchar2(1);

         fdeses DATE;

         nimpug number; 

         numeroacta number:=0;

         impugcorrecta varchar2(4):='ok';

         contadorf number:=0;

         nactacompletovar varchar2(15);

         territ varchar2(2):='00';

         anoacta number:=0;

         ver number:=0;

         numRegDef number;

         fe DATE;

         numEntrada varchar2(15);

         cif varchar2(10);

         numCentro number;

         razonSocial varchar2(50);

         direccion varchar2(50);

         numTrabajadores number;

         numRepresentantes number;

         nactacompleto varchar2(15);

         provincia varchar2(2);

         municipio varchar2(3);

         prov varchar2(2);

         mun varchar2(3); 

         seccion varchar2(2);

         seccionVar varchar2(2);

         CURSOR actasConsultar IS

            SELECT   consulta.ver, consulta.anoacta, consulta.territ, consulta.nacta, consulta.fechaentrada, 

            consulta.numreg, consulta.cif, consulta.numcentro, consulta.razon,

            consulta.domicilio, consulta.numelectores,

            consulta.numrepresentantes, consulta.nactaintcompleto, consulta.nimpug, consulta.fdeses, consulta.lau, consulta.provincia, consulta.municipio, consulta.seccion

       FROM (SELECT actas.version_016 as ver,

            actas.ano_acta_016 as anoacta,

            actas.c_territ_016 as territ,

            actas.n_acta_016 as nacta, 

            actas.f_entra_016 as fechaentrada, 

              actas.c_territ_016 || '/' 

                || actas.ano_acta_016 || '/' 

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

                as numreg,

            centros.ccif_001 as cif,

            centros.ncen_001 as numcentro,

            centros.rsoc_001 as razon, 

            centros.domic_001 as domicilio, 

            actas.totelec_016 as numelectores, 

            impugnaciones.fdeses_033 as fdeses,

            impugnaciones.n_impug_033 as nimpug,

            laudos.rdo_laudo_068 as lau,

            centros.provc_001 as provincia,

            centros.munic_001 as municipio,

            centros.secc_001 as seccion,

            count(delegados.dni_025) as numrepresentantes,

            TO_NUMBER

               (   actas.c_territ_016

                || actas.ano_acta_016

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

               ) AS nactaintcompleto

       FROM w83b33s00 impugnaciones,

            w83b16s00 actas,

            w83b25s00 delegados,

            w83b68s00 laudos,

            j7301s01 centros

      WHERE impugnaciones.n_acta_033(+) = actas.n_acta_016

        AND impugnaciones.ano_acta_033(+) = actas.ano_acta_016

        AND impugnaciones.c_territ_033(+) = actas.c_territ_016

        AND impugnaciones.version_033(+) = actas.version_016

        AND actas.n_acta_016 = delegados.n_acta_025(+)

        AND actas.ano_acta_016 = delegados.ano_acta_025(+)

        AND actas.c_territ_016 = delegados.c_territ_025(+)

        AND actas.version_016 = delegados.version_025(+)

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND actas.id_centro_016 = centros.ccen_001

        AND actas.f_baja_016 IS NULL

        AND actas.fregdef_016 IS NULL

        AND actas.n_regdef_016 IS NULL

        --AND (actas.f_reque_016 IS NULL OR (actas.f_reque_016 IS NOT NULL AND actas.f_subreq_016 IS NOT NULL))

        AND actas.n_preaviso_016 IS NOT NULL

        --AND (   actas.s_comi_016 = 'N'

             --OR actas.s_comi_016 IS NULL

             --OR (actas.s_comi_016 = 'S' AND actas.f_comis_016 IS NOT NULL)

            --)

        AND ACTAS.F_ENTRA_016<=TO_DATE(fechaEntrada,'dd/MM/yyyy') 

        AND ACTAS.C_TERRIT_016=territorio 

        AND delegados.cbaja_025 IS NULL

       GROUP BY

        actas.version_016,actas.ano_acta_016,

            actas.c_territ_016,actas.n_acta_016, actas.f_entra_016, actas.n_reg_016,

            centros.ccif_001, centros.ncen_001,

            centros.rsoc_001, centros.domic_001, 

            actas.totelec_016, impugnaciones.fdeses_033, impugnaciones.n_impug_033,laudos.rdo_laudo_068,

            centros.provc_001,centros.munic_001,centros.secc_001,

             TO_NUMBER

               (   actas.c_territ_016

                || actas.ano_acta_016

                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                           1, '00000' || TO_CHAR (actas.n_acta_016),

                           2, '0000' || TO_CHAR (actas.n_acta_016),

                           3, '000' || TO_CHAR (actas.n_acta_016),

                           4, '00' || TO_CHAR (actas.n_acta_016),

                           5, '0' || TO_CHAR (actas.n_acta_016),

                           TO_CHAR (actas.n_acta_016)

                          )

               )) consulta

            WHERE consulta.ver =

               (SELECT MAX (version_016)

                  FROM w83b16s00 act

                 WHERE consulta.nacta = act.n_acta_016

                   AND consulta.anoacta = act.ano_acta_016

                   AND consulta.territ = c_territ_016)

   ORDER BY consulta.fechaentrada, consulta.nactaintcompleto;     

   BEGIN

       OPEN actasConsultar;     

       LOOP

            FETCH actasConsultar INTO versionVar, anoactaVar, territVar, numActaVar,fechaEntradaVar,numEntradaVar,cifVar,numCentroVar,razonSocialVar,direccionVar,numTrabajadoresVar,numRepresentantesVar,nactacompletoVar, nimpug, fdeses, lau,prov,mun,seccionVar;

            EXIT WHEN actasConsultar%NOTFOUND;

            IF (numeroacta!=numActaVar OR territ!=territVar OR anoacta!=anoactaVar OR ver!=versionVar) THEN

                IF (impugcorrecta='ok') THEN

                    IF (contadorf!=0) THEN

                        UPDATE w83b16t00

                    SET ANO_REGDEF_016= annoRegistro, N_REGDEF_016= numRegistro+contador-1, FREGDEF_016=TO_DATE(fechaRegistro,'dd/MM/yyyy') WHERE c_territ_016=territ AND n_acta_016=numeroacta AND ano_acta_016=anoacta AND version_016=ver;

                        v_tabla_detalleActa.EXTEND;

                        v_tabla_detalleActa(contador) := detalleActa(numRegDef,

                        fe,

                        numEntrada,

                        numeroacta,

                        cif,

                        numCentro,

                        razonSocial,

                        direccion,

                        numTrabajadores,

                        numRepresentantes,territ,anoacta,nactacompleto,provincia,municipio,seccion,ver);

                        contador:=contador+1;

                    END IF;

                END IF;

                impugcorrecta:='ok';

                IF (nimpug IS NOT NULL) THEN

                    IF (lau IS NULL OR lau=1 OR fdeses IS NOT NULL) THEN

                        impugcorrecta:='nook';

                    END IF;

                END IF;

            ELSE

               IF (nimpug IS NOT NULL) THEN

                    IF (lau IS NULL OR lau=1 OR fdeses IS NOT NULL) THEN

                        impugcorrecta:='nook';

                    END IF;

                END IF; 

            END IF;

            contadorf:=contadorf+1;

            numeroacta:=numActaVar;

            territ:=territVar;

            anoacta:=anoactaVar;

            ver:=versionVar;

            numRegDef:=numRegDefVar;

            fe:=fechaEntradaVar;

            numEntrada:=numEntradaVar;

            cif:=cifVar;

            numCentro:=numCentroVar;

            razonSocial:=razonSocialVar;

            direccion:=direccionVar;

            numTrabajadores:=numTrabajadoresVar;

            numRepresentantes:=numRepresentantesVar;

            nactacompleto:=nactacompletoVar;

            provincia:=prov;

            municipio:=mun;

            seccion:=seccionVar;

        END LOOP;

         

                IF (impugcorrecta='ok') THEN

                        UPDATE w83b16t00

                    SET ANO_REGDEF_016= annoRegistro, N_REGDEF_016= numRegistro+contador-1, FREGDEF_016=TO_DATE(fechaRegistro,'dd/MM/yyyy') WHERE c_territ_016=territ AND n_acta_016=numeroacta AND ano_acta_016=anoacta AND version_016=ver;

                        v_tabla_detalleActa.EXTEND;

                        v_tabla_detalleActa(contador) := detalleActa(numRegDef,

                        fe,

                        numEntrada,

                        numeroacta,

                        cif,

                        numCentro,

                        razonSocial,

                        direccion,

                        numTrabajadores,

                        numRepresentantes,territ,anoacta,nactacompleto,provincia,municipio,seccion,ver);

                        contador:=contador+1;

                    

                END IF;

            

        CLOSE actasConsultar;

        COMMIT;

   RETURN v_tabla_detalleActa;

   

END REGDEFMOD;

/



/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION      w83bcabdelegsindconv(fechaEleccionDesde IN VARCHAR2,fechaEleccionHasta IN VARCHAR2,fechaRegistro IN VARCHAR2,territorio IN VARCHAR2,trabajadores IN VARCHAR2,fechaActualizacion IN VARCHAR2)

     RETURN tabla_cabdelegsindconv

     IS

         v_tabla_cabdelegsindconv tabla_cabdelegsindconv := tabla_cabdelegsindconv();

         totelectoresVar NUMBER;

         totalvotosVar NUMBER;

         empresaVar VARCHAR2(10);

         numcentrosVar NUMBER;

         contador NUMBER:=1;

         QUERY VARCHAR2(30000);

         TYPE cur_typ IS REF CURSOR;

         actasConsultar    CUR_TYP;



BEGIN

QUERY := 'SELECT  SUM(consulta.totalelectores) AS totalelectores, NVL(SUM(consulta.votos),0) AS totalvotos, ';

QUERY := QUERY || 'consulta.cif AS empresa, COUNT(DISTINCT(consulta.centro)) AS numcentros ';

QUERY := QUERY || 'FROM (SELECT actas.version_016 AS ver, ';

QUERY := QUERY || 'actas.ano_acta_016 AS anoacta,actas.c_territ_016 AS territ,actas.n_acta_016 AS nacta,actas.totelec_016 AS totalelectores, ';

QUERY := QUERY || 'centros.ncen_001 AS CENTRO,centros.ccif_001 AS CIF,SUM(papeletas.vota_044) AS votos ';

QUERY := QUERY || 'FROM w83b16s00 actas, w83b44s00 papeletas,j7301s01 centros ';

QUERY := QUERY || 'WHERE actas.id_centro_016 = centros.ccen_001 AND actas.n_acta_016 = papeletas.n_acta_044(+) ';

QUERY := QUERY || 'AND actas.ano_acta_016 = papeletas.ano_acta_044(+) ';

QUERY := QUERY || 'AND actas.c_territ_016 = papeletas.c_territ_044(+) ';

QUERY := QUERY || 'AND actas.version_016 = papeletas.version_044(+) ';

QUERY := QUERY || ' AND actas.n_acttot_016 IS NULL AND (actas.f_baja_016 IS NULL OR (actas.f_baja_016 IS NOT NULL AND actas.f_baja_016>TO_DATE('''||fechaEleccionHasta||''','; 

QUERY := QUERY || '''dd/MM/yyyy'''||' )))'; 

QUERY := QUERY || ' AND actas.f_elecc_016>=TO_DATE('''||fechaEleccionDesde||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||')';

QUERY := QUERY || ' AND actas.f_elecc_016<=TO_DATE('''||fechaEleccionHasta||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||') AND actas.fregdef_016<=TO_DATE('''|| fechaRegistro||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||') ';

QUERY := QUERY || ' AND actas.N_PREAVISO_016 IS NOT NULL ';

QUERY := QUERY || ' AND actas.validada_016 = 1 ';

IF (territorio='todos') THEN

     QUERY := QUERY || 'AND actas.c_territ_016 IN (01,20,48) ';

ELSE

     QUERY := QUERY || 'AND actas.c_territ_016 = '|| territorio;

END IF;

QUERY := QUERY || ' GROUP BY actas.version_016,actas.ano_acta_016,actas.c_territ_016,actas.n_acta_016,actas.totelec_016,centros.ncen_001,centros.ccif_001 ';

IF (trabajadores<>'todos') THEN

QUERY := QUERY || 'HAVING actas.totelec_016'|| trabajadores;

END IF;

QUERY := QUERY || ')consulta ';

QUERY := QUERY || 'WHERE consulta.ver =(SELECT MAX (version_016) FROM w83b16s00 act WHERE ';

IF (fechaActualizacion<>'vacio') THEN

        QUERY := QUERY || '  act.FACTU_016 <=TO_DATE('''||fechaActualizacion||' 23:59:59''  ,';

    	QUERY := QUERY || '''dd/MM/yyyy hh24:mi:ss'''||') AND ';

END IF;

QUERY := QUERY || '  consulta.nacta = act.n_acta_016 AND consulta.anoacta = act.ano_acta_016 AND consulta.territ = c_territ_016) ';

QUERY := QUERY || 'GROUP BY consulta.cif ';





      DBMS_OUTPUT.PUT_LINE(QUERY);



       OPEN actasConsultar FOR QUERY;

        LOOP

         FETCH actasConsultar INTO totelectoresVar,totalvotosVar,empresaVar,numcentrosVar;

         EXIT WHEN actasConsultar%NOTFOUND;

               v_tabla_cabdelegsindconv.EXTEND;

               v_tabla_cabdelegsindconv(contador) := cabdelegsindconv(totelectoresVar,

               totalvotosVar,

               empresaVar,

               numcentrosVar);

               contador:=contador+1;

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_cabdelegsindconv;



END w83bcabdelegsindconv; 

/



/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION      w83bempresasvariospreavisos(fechaEntradadesde IN VARCHAR2,fechaEntradahasta IN VARCHAR2)

     RETURN tabla_empresavariospreavisos

     IS

         v_tabla_empresavariospreavisos tabla_empresavariospreavisos := tabla_empresavariospreavisos(); 

         contador NUMBER:=1;

         cif VARCHAR2(10);

         codigocentro NUMBER;

         razon  VARCHAR2(50);

         fechaentrada DATE;

         numpreaviso VARCHAR2(15);

         numpreavisoint NUMBER;

         fechainicio DATE;

         municipio VARCHAR2(50);

         preavisoglobal VARCHAR2(1);

         observaciones VARCHAR2(500);

         promotores VARCHAR2(10000);

         promotoreseu VARCHAR2(10000);

         territ VARCHAR2(2);

         

         CURSOR actasConsultar IS

SELECT   centros.ccif_001 AS cif, centros.ncen_001 AS codigocentro,

            centros.rsoc_001 AS razon, preavisos.f_entra_037,

               preavisos.c_territ_037

            || '/'

            || preavisos.ano_preaviso_037

            || '/'

            || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                       1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                       2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                       3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                       4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                       5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                       TO_CHAR (preavisos.n_preaviso_037)

                      ) AS numpreaviso,

            TO_NUMBER

               (   preavisos.c_territ_037

                || preavisos.ano_preaviso_037

                || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                           1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                           2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                           3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                           4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                           5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                           TO_CHAR (preavisos.n_preaviso_037)

                          )

               ) AS numpreavisoint,

            preavisos.f_inicio_037 AS fechainicio,

            municipios.ds_o AS municipio,

            preavisos.global_037 AS preavisoglobal,

            preavisos.observ_037 AS observaciones,

            stragg (sind.desc_019) AS promotores, stragg (sind.dese_019) AS promotoreseu, preavisos.c_territ_037

       FROM w83b37s00 preavisos,

            j7301s01 centros,

            t17i.t17_municipio municipios,

            w83b27s00 preav_sin,

            w83b19s00 sind

      WHERE centros.ccen_001 = preavisos.id_centro_037

        AND centros.munic_001 = municipios.ID

        AND centros.provf_001 = municipios.provincia_id

        AND preavisos.n_preaviso_037 = preav_sin.n_preaviso_027(+)

        AND preavisos.ano_preaviso_037 = preav_sin.ano_preaviso_027(+)

        AND preavisos.c_territ_037 = preav_sin.c_territ_027(+)

        AND preav_sin.c_sindi_027 = sind.c_sindi_019(+)

		 AND preavisos.f_entra_037>=TO_DATE(fechaEntradaDesde,'dd/MM/yyyy')

        AND preavisos.f_entra_037<=TO_DATE(fechaEntradaHasta,'dd/MM/yyyy')

        AND preavisos.id_centro_037 IN (

                    SELECT pre.ccen_001

                      FROM (SELECT   centros.ccen_001, COUNT (*) AS cantidad

                                FROM j7301s01 centros, w83b37s00 preavisos

                               WHERE centros.ccen_001 = preavisos.id_centro_037

                               AND preavisos.f_entra_037>=TO_DATE(fechaEntradaDesde,'dd/MM/yyyy')

                               AND preavisos.f_entra_037<=TO_DATE(fechaEntradaHasta,'dd/MM/yyyy')

                            GROUP BY centros.ccen_001) pre

                     WHERE pre.cantidad > 1)

   GROUP BY centros.ccif_001,

            centros.ncen_001,

            centros.rsoc_001,

            preavisos.f_entra_037,

               preavisos.c_territ_037

            || '/'

            || preavisos.ano_preaviso_037

            || '/'

            || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                       1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                       2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                       3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                       4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                       5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                       TO_CHAR (preavisos.n_preaviso_037)

                      ),

            TO_NUMBER (   preavisos.c_territ_037

                       || preavisos.ano_preaviso_037

                       || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                                  1,  '00000'

                                   || TO_CHAR (preavisos.n_preaviso_037),

                                  2, '0000'

                                   || TO_CHAR (preavisos.n_preaviso_037),

                                  3, '000'

                                   || TO_CHAR (preavisos.n_preaviso_037),

                                  4, '00'

                                   || TO_CHAR (preavisos.n_preaviso_037),

                                  5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                                  TO_CHAR (preavisos.n_preaviso_037)

                                 )

                      ),

            preavisos.f_inicio_037,

            municipios.ds_o,

            preavisos.global_037,

            preavisos.observ_037,

            preavisos.c_territ_037

   ORDER BY centros.ccif_001, centros.ncen_001,TO_DATE(preavisos.f_entra_037,'dd/MM/yyyy') ASC, numpreavisoint;              

   BEGIN

       OPEN actasConsultar;     

       LOOP

         FETCH actasConsultar INTO cif,codigocentro,razon,fechaentrada,numpreaviso,numpreavisoint,fechainicio,municipio,preavisoglobal,

         observaciones,promotores,promotoreseu,territ;

            EXIT WHEN actasConsultar%NOTFOUND;

               v_tabla_empresavariospreavisos.EXTEND;

               v_tabla_empresavariospreavisos(contador) := empresavariospreavisos(cif,codigocentro,razon,fechaentrada,numpreaviso,numpreavisoint,fechainicio,municipio,preavisoglobal,

                observaciones,promotores,promotoreseu,territ);

               contador:=contador+1;

                        

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_empresavariospreavisos;

   

END w83bempresasvariospreavisos; 

/



/* **************************************************************************************************** */



CREATE OR REPLACE FUNCTION      w83bresoldeneglaudonegativo(fechaEntrada IN VARCHAR2,territorio IN VARCHAR2, patron IN VARCHAR2)

     RETURN tabla_resoldeneglaudoneg

     IS

         v_tabla_resoldeneglaudoneg tabla_resoldeneglaudoneg := tabla_resoldeneglaudoneg(); 

         versionVar NUMBER;

         fechaEntradaVar DATE;

         numActaVar NUMBER;

         anoActaVar NUMBER;

         territVar VARCHAR2(2);

         npreVar NUMBER;

         anopreavisoVar NUMBER;

         razonVar VARCHAR2(50);

         domicilioVar VARCHAR2(50);

         municipioVar VARCHAR2(50);

         numelectoresVar NUMBER;

         numrepVar NUMBER;

         frequeVar DATE;

         fregdefVar DATE;

         fimpugVar DATE;

         contador NUMBER:=1;

         fechalaudo VARCHAR2(10000);

         rdolaudo VARCHAR2(10000);

         rd emb_string.string_array;

         fd emb_string.string_array;

         numaactaint NUMBER;

         CURSOR actasConsultar IS

SELECT   consulta.ver, consulta.fechaentrada, consulta.nacta,

            consulta.anoacta, consulta.territ, consulta.npre, consulta.anopreaviso, consulta.razon,

            consulta.domicilio, consulta.municipio, consulta.numelectores,

            consulta.freque, consulta.fregdef, consulta.fimpug,consulta.fechalaudo,

            consulta.rdolaudo,COUNT(consulta.numrepresentantes), consulta.numaactaint

       FROM (SELECT  actas.version_016 AS ver,

        actas.f_entra_016 AS fechaentrada,

        actas.n_acta_016 AS nacta,

        actas.ano_acta_016 AS anoacta,

        actas.c_territ_016 AS territ,

        actas.n_preaviso_016 AS npre,

        actas.ano_preaviso_016 AS anopreaviso, 

        centros.rsoc_001 AS razon,

        centros.domic_001 AS domicilio,

        municipios.ds_o AS municipio,

        totelec_016 AS numelectores,

        actas.f_reque_016 AS freque,

        actas.fregdef_016 AS fregdef,

        MAX (impugnaciones.f_impug_033) AS fimpug,              

        NVL(stragg (TO_CHAR(laudos.FLAUDO_068,patron)),0) AS fechalaudo,

        NVL(stragg (laudos.rdo_laudo_068),0) AS rdolaudo,

        delegados.dni_025 AS numrepresentantes,

        TO_NUMBER

                         (   actas.c_territ_016

                          || actas.ano_acta_016

                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                     1, '00000' || TO_CHAR (actas.n_acta_016),

                                     2, '0000' || TO_CHAR (actas.n_acta_016),

                                     3, '000' || TO_CHAR (actas.n_acta_016),

                                     4, '00' || TO_CHAR (actas.n_acta_016),

                                     5, '0' || TO_CHAR (actas.n_acta_016),

                                     TO_CHAR (actas.n_acta_016)

                                    )

                         ) AS numaactaint

       FROM w83b16s00 actas,

            w83b33s00 impugnaciones,

            w83b68s00 laudos,

            t17i.t17_municipio municipios,

            j7301s01 centros,

            w83b25s00 delegados

      WHERE centros.ccen_001 = actas.id_centro_016

        AND centros.munic_001 = municipios.ID

        AND centros.provc_001 = municipios.provincia_id

        AND actas.n_acta_016 = impugnaciones.n_acta_033

        AND actas.ano_acta_016 = impugnaciones.ano_acta_033

        AND actas.c_territ_016 = impugnaciones.c_territ_033

        AND actas.version_016 = impugnaciones.version_033

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068

        AND impugnaciones.n_impug_033 = laudos.n_impug_068

        AND impugnaciones.c_territ_033 = laudos.c_territ_068

        AND actas.n_acta_016 = delegados.n_acta_025(+)

        AND actas.ano_acta_016 = delegados.ano_acta_025(+)

        AND actas.c_territ_016 = delegados.c_territ_025(+)

        AND actas.version_016 = delegados.version_025(+)

        AND actas.c_territ_016 = territorio

        AND delegados.cbaja_025 IS NULL

       GROUP BY

        actas.version_016,

        actas.f_entra_016,

        actas.n_acta_016,

        actas.ano_acta_016,

        actas.c_territ_016,

        actas.n_preaviso_016, 

        actas.ano_preaviso_016,

        centros.rsoc_001,

        centros.domic_001,

        municipios.ds_o,

        totelec_016,

        actas.f_reque_016,

        actas.fregdef_016,

        delegados.dni_025,

        TO_NUMBER

                         (   actas.c_territ_016

                          || actas.ano_acta_016

                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                     1, '00000' || TO_CHAR (actas.n_acta_016),

                                     2, '0000' || TO_CHAR (actas.n_acta_016),

                                     3, '000' || TO_CHAR (actas.n_acta_016),

                                     4, '00' || TO_CHAR (actas.n_acta_016),

                                     5, '0' || TO_CHAR (actas.n_acta_016),

                                     TO_CHAR (actas.n_acta_016)

                                    )

                         )) consulta

      WHERE consulta.ver =

               (SELECT MAX (version_016)

                  FROM w83b16s00 act

                 WHERE consulta.nacta = act.n_acta_016

                   AND consulta.anoacta = act.ano_acta_016

                   AND consulta.territ = c_territ_016)

      GROUP BY consulta.ver, consulta.fechaentrada, consulta.nacta,

            consulta.anoacta, consulta.territ, consulta.npre, consulta.anopreaviso, consulta.razon,

            consulta.domicilio, consulta.municipio, consulta.numelectores,

            consulta.freque, consulta.fregdef, consulta.fimpug,consulta.fechalaudo,

            consulta.rdolaudo, consulta.numaactaint

   ORDER BY consulta.numaactaint;                   

   BEGIN

       OPEN actasConsultar;     

       LOOP

         FETCH actasConsultar INTO versionVar,fechaEntradaVar,numActaVar,anoActaVar,

         territVar,npreVar,anopreavisoVar, razonVar,domicilioVar,municipioVar,numelectoresVar,frequeVar,

         fregdefVar,fimpugVar,fechalaudo, rdolaudo,numrepVar,numaactaint;

            EXIT WHEN actasConsultar%NOTFOUND;

            IF (rdolaudo!='0') THEN

                 rd := emb_string.split_string(rdolaudo);

                 fd := emb_string.split_string(fechalaudo);

                 FOR i IN 1..rd.COUNT LOOP

                    IF (rd(i)=1) THEN

                        IF (TO_DATE(fd(i),patron)>=TO_DATE(fechaEntrada,patron)) THEN

                            v_tabla_resoldeneglaudoneg.EXTEND;

                            v_tabla_resoldeneglaudoneg(contador) := resoldeneglaudoneg(fechaEntradaVar,

                            numActaVar,

                            anoActaVar,

                            territVar,

                            npreVar,

                            anopreavisoVar,

                            razonVar,

                            domicilioVar,

                            municipioVar,

                            numelectoresVar,

                            numrepVar,

                            frequeVar,

                            fimpugVar,

                            fregdefVar);

                            contador:=contador+1;

                        END IF;

                    END IF;

                    EXIT WHEN rd(i) = 1;

                END LOOP;

            END IF;

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_resoldeneglaudoneg;

   

END w83bresoldeneglaudonegativo; 

/

/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION w83bdelegsindconvenio(fechaEleccionDesde IN VARCHAR2,fechaEleccionHasta IN VARCHAR2,fechaRegistro IN VARCHAR2,territorio IN VARCHAR2,trabajadores IN VARCHAR2,fechaActualizacion IN VARCHAR2)

     RETURN tabla_detalledelegsindconv

     IS

         v_tabla_detalledelegsindconv tabla_detalledelegsindconv := tabla_detalledelegsindconv();

         nactaVar NUMBER;

         anoactaVar NUMBER;

         verVar NUMBER;

         codConvVar NUMBER;

         codigoVar NUMBER;

         siglasVar VARCHAR2(10);

         descripVar VARCHAR2(250);

         descripeuVar VARCHAR2(250);

         tConvenioVar VARCHAR2(1);

         territVar VARCHAR2(2);

         numdelegadosVar NUMBER;

         totelectoresVar NUMBER;

         nVar NUMBER;

         anoVar NUMBER;

         ncentroVar NUMBER;

         cifVar VARCHAR2(10);

         razonVar VARCHAR2(50);

         felecVar DATE;

         factuVar DATE;

         contador NUMBER:=1;

         QUERY VARCHAR2(30000);

         TYPE cur_typ IS REF CURSOR;

         actasConsultar    CUR_TYP;



    BEGIN

QUERY := QUERY || 'SELECT actas.n_acta_016 AS nacta, actas.ano_acta_016 AS anoacta, actas.c_territ_016 AS territ, actas.version_016 AS ver, ';

QUERY := QUERY || 'actas.c_conv_016 AS convenio, sindicatos.c_sindi_019 AS codsindi, sindicatos.siglas_019 AS siglas,sindicatos.desc_019 AS descripcion,sindicatos.dese_019 AS descripcioneu,';

QUERY := QUERY || '(CASE WHEN (length(actas.c_conv_016)=3 AND SUBSTR(actas.c_conv_016, 1, 1) = 9) THEN' || ' ''F'' '|| 'ELSE' || ' ''L'' '|| 'END) as tipoconvenio,';

QUERY := QUERY || 'COUNT(delegados.dni_025) AS numdelegados, actas.totelec_016,actas.n_regdef_016 AS nregdef, actas.ano_regdef_016 AS anoregdef, ';

QUERY := QUERY || 'centros.ncen_001, centros.ccif_001, centros.rsoc_001, actas.F_ELECC_016,actas.FACTU_016 ';

QUERY := QUERY || 'FROM w83b16s00 actas, j7301s01 centros, w83b25s00 delegados, w83b19s00 sindicatos ';

QUERY := QUERY || 'WHERE ';

QUERY := QUERY || ' actas.id_centro_016 = centros.ccen_001 AND actas.n_acta_016 = delegados.n_acta_025(+) AND actas.ano_acta_016 = delegados.ano_acta_025(+) ';

QUERY := QUERY || ' AND actas.c_territ_016 = delegados.c_territ_025(+) ';

QUERY := QUERY || 'AND actas.version_016 = delegados.version_025(+) AND delegados.c_sindi_025=sindicatos.c_sindi_019(+) ';

IF (territorio='todos') THEN

     QUERY := QUERY || 'AND actas.c_territ_016 IN (01,20,48) ';

ELSE

     QUERY := QUERY || 'AND actas.c_territ_016 = '|| territorio;

END IF;

QUERY := QUERY || ' AND actas.n_acttot_016 IS NULL AND (actas.f_baja_016 is null or (actas.f_baja_016 is not null and actas.f_baja_016>TO_DATE('''||fechaEleccionHasta||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||' )))';

QUERY := QUERY || ' AND actas.f_elecc_016>=TO_DATE('''||fechaEleccionDesde||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||')';

QUERY := QUERY || ' AND actas.f_elecc_016<=TO_DATE('''||fechaEleccionHasta||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||') AND actas.fregdef_016<=TO_DATE('''|| fechaRegistro||''',';

QUERY := QUERY || '''dd/MM/yyyy'''||') ';

IF (fechaActualizacion<>'nohay') THEN

    QUERY := QUERY || ' AND actas.factu_016 <=TO_DATE('''||fechaActualizacion||' 23:59:59''  ,';

    QUERY := QUERY || '''dd/MM/yyyy hh24:mi:ss'''||') ';

END IF;

QUERY := QUERY || 'AND actas.n_regdef_016 IS NOT NULL ';

--QUERY := QUERY || 'AND actas.N_PREAVISO_016 IS NOT NULL AND delegados.CBAJA_025(+) IS NULL';

QUERY := QUERY || 'AND delegados.CBAJA_025(+) IS NULL';

QUERY := QUERY || ' AND actas.validada_016 = 1 ';







----

QUERY := QUERY || ' GROUP BY actas.n_acta_016,actas.c_territ_016, actas.ano_acta_016,actas.version_016,sindicatos.desc_019,sindicatos.dese_019,sindicatos.c_sindi_019,sindicatos.siglas_019,';

QUERY := QUERY || 'actas.C_CONV_016, actas.totelec_016,actas.n_regdef_016, actas.ano_regdef_016,centros.ncen_001, centros.ccif_001, centros.rsoc_001, actas.F_ELECC_016,actas.FACTU_016 ';

IF (trabajadores<>'todos') THEN

QUERY := QUERY || 'HAVING actas.totelec_016'|| trabajadores;

END IF;

QUERY := QUERY || ' ORDER BY actas.n_acta_016,actas.c_territ_016,actas.ano_acta_016,actas.version_016 DESC, ';

QUERY := QUERY || ' sindicatos.c_sindi_019,(CASE WHEN (length(actas.c_conv_016)=3 AND SUBSTR(actas.c_conv_016, 1, 1) = 9) THEN' || ' ''F'' '|| 'ELSE' || ' ''L'' '|| 'END) ';





      DBMS_OUTPUT.PUT_LINE(QUERY);



       OPEN actasConsultar FOR QUERY;

        LOOP

         FETCH actasConsultar INTO nactaVar,anoactaVar,territVar,verVar,codConvVar,codigoVar,siglasVar,descripVar,descripeuVar,tConvenioVar,numdelegadosVar,totelectoresVar,nVar,anoVar,ncentroVar, cifVar,razonVar,felecVar,factuVar;

         EXIT WHEN actasConsultar%NOTFOUND;

               v_tabla_detalledelegsindconv.EXTEND;

               v_tabla_detalledelegsindconv(contador) := detalledelegsindconv(nactaVar,anoactaVar,territVar,verVar,codigoVar,siglasVar,

               descripVar,

               descripeuVar,

               tConvenioVar,

               numdelegadosVar,nVar,anoVar,ncentroVar, cifVar,razonVar,felecVar,factuVar);

               contador:=contador+1;

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_detalledelegsindconv;



END w83bdelegsindconvenio;

/



/* **************************************************************************************************** */

COMMIT;



CREATE OR REPLACE FUNCTION W83B.w83bcomimpugresueltas(fimpugdesde IN VARCHAR2, fimpughasta IN VARCHAR2, territorio IN VARCHAR2, patron IN VARCHAR2)

     RETURN tabla_comimpugresueltas

     IS

         v_tabla_comimpugresueltas tabla_comimpugresueltas := tabla_comimpugresueltas();

         nactaVar NUMBER;

         anoactaVar NUMBER;

         territVar VARCHAR2(50);

         razonVar VARCHAR2(50);

         domicilioVar VARCHAR2(50);

         municipioVar NUMBER;

         provinciaVar NUMBER;

         nimpugVar VARCHAR2(10000);

         numactaintVar NUMBER;

         orderbyVar VARCHAR2(1);

         contador NUMBER:=1;

         codigopostalVar VARCHAR2(5);

       CURSOR actasConsultar IS

SELECT   actas.n_acta_016 AS nacta, actas.ano_acta_016 AS anoacta,

            actas.c_territ_016 AS territ, centros.rsoc_001 AS razon,

            centros.domic_001 AS domicilio, centros.munic_001 AS municipio,

            centros.provc_001 AS provincia, stragg(impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||to_char(laudos.FLAUDO_068,'dd/MM/yyyy')) AS nimpug,

            TO_NUMBER

                   (   actas.c_territ_016

                    || actas.ano_acta_016

                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                               1, '00000' || TO_CHAR (actas.n_acta_016),

                               2, '0000' || TO_CHAR (actas.n_acta_016),

                               3, '000' || TO_CHAR (actas.n_acta_016),

                               4, '00' || TO_CHAR (actas.n_acta_016),

                               5, '0' || TO_CHAR (actas.n_acta_016),

                               TO_CHAR (actas.n_acta_016)

                              )

                   ) AS numaactaint,

            '1' AS orderby,

            centros.CPOSC_001 as codigopostal

       FROM w83b16s00 actas,

            j7301s01 centros,

            w83b33s00 impugnaciones,

            w83b68s00 laudos

      WHERE centros.ccen_001 = actas.id_centro_016

        AND actas.n_acta_016 = impugnaciones.n_acta_033

        AND actas.ano_acta_016 = impugnaciones.ano_acta_033

        AND actas.c_territ_016 = impugnaciones.c_territ_033

        AND actas.version_016 = impugnaciones.version_033

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND impugnaciones.FDESES_033 IS NULL

        AND actas.version_016 = 0

        AND actas.validada_016 = 1

        AND actas.F_BAJA_016 IS NULL

        AND actas.N_ACTTOT_016 IS NULL

        AND actas.c_territ_016 = territorio

        AND f_impug_033 >= TO_DATE (fimpugdesde, patron)

        AND f_impug_033 <= TO_DATE (fimpughasta, patron)

      GROUP BY

      actas.n_acta_016, actas.ano_acta_016,

            actas.c_territ_016, centros.rsoc_001,

            centros.domic_001, centros.munic_001,

            centros.provc_001,

            TO_NUMBER

                   (   actas.c_territ_016

                    || actas.ano_acta_016

                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                               1, '00000' || TO_CHAR (actas.n_acta_016),

                               2, '0000' || TO_CHAR (actas.n_acta_016),

                               3, '000' || TO_CHAR (actas.n_acta_016),

                               4, '00' || TO_CHAR (actas.n_acta_016),

                               5, '0' || TO_CHAR (actas.n_acta_016),

                               TO_CHAR (actas.n_acta_016)

                              )

                   ),

            '1',

            centros.CPOSC_001

   UNION ALL

   SELECT   preavisos.n_preaviso_037 AS nacta,

            preavisos.ano_preaviso_037 AS anoacta,

            preavisos.c_territ_037 AS territ, centros.rsoc_001 AS razon,

            centros.domic_001 AS domicilio, centros.munic_001 AS municipio,

            centros.provc_001 AS provincia, stragg(impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||to_char(laudos.FLAUDO_068,'dd/MM/yyyy')) AS nimpug,

            TO_NUMBER

               (   preavisos.c_territ_037

                || preavisos.ano_preaviso_037

                || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                           1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                           2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                           3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                           4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                           5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                           TO_CHAR (preavisos.n_preaviso_037)

                          )

               ) AS numaactaint,

            '2' AS orderby,

            centros.CPOSC_001 as codigopostal

       FROM w83b37s00 preavisos,

            j7301s01 centros,

            w83b33s00 impugnaciones,

            w83b68s00 laudos

      WHERE centros.ccen_001 = preavisos.id_centro_037

        AND preavisos.n_preaviso_037 = impugnaciones.n_preaviso_033

        AND preavisos.ano_preaviso_037 = impugnaciones.ano_preaviso_033

        AND preavisos.c_territ_037 = impugnaciones.c_territ_033

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND impugnaciones.FDESES_033 IS NULL

        AND preavisos.c_territ_037 = territorio

        AND f_impug_033 >= TO_DATE (fimpugdesde, patron)

        AND f_impug_033 <= TO_DATE (fimpughasta, patron)

     GROUP BY

      preavisos.n_preaviso_037,

            preavisos.ano_preaviso_037,

            preavisos.c_territ_037, centros.rsoc_001,

            centros.domic_001, centros.munic_001,

            centros.provc_001, 

            TO_NUMBER

               (   preavisos.c_territ_037

                || preavisos.ano_preaviso_037

                || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                           1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                           2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                           3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                           4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                           5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                           TO_CHAR (preavisos.n_preaviso_037)

                          )

               ),

            '2',

            centros.CPOSC_001

   ORDER BY orderby, numaactaint;



   BEGIN

       OPEN actasConsultar;

       LOOP

         FETCH actasConsultar INTO nactaVar,anoactaVar,territVar,razonVar,

         domicilioVar,municipioVar,provinciaVar,nimpugVar,numactaintVar,orderbyVar,codigopostalVar;

            EXIT WHEN actasConsultar%NOTFOUND;

                            v_tabla_comimpugresueltas.EXTEND;

                            v_tabla_comimpugresueltas(contador) := comimpugresueltas(nactaVar,

                            anoactaVar,

                            territVar,

                            razonVar,

                            domicilioVar,

                            municipioVar,

                            provinciaVar,

                            nimpugVar,

                            codigopostalVar,

                            orderbyVar);

                            contador:=contador+1;

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_comimpugresueltas;



END w83bcomimpugresueltas;

/





/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION w83bcomlaudonegativo(fechaentrada IN VARCHAR2,territorio IN VARCHAR2, patron IN VARCHAR2)

     RETURN tabla_comimpugresueltas

     IS

         v_tabla_comimpugresueltas tabla_comimpugresueltas := tabla_comimpugresueltas(); 

         fechaEntradaVar DATE;

         nactaVar number;

         anoactaVar number;

         territVar varchar2(2);

         razonVar varchar2(50);

         domicilioVar varchar2(50);

         municipioVar NUMBER;

         provinciaVar NUMBER;

         codigopostalVar varchar2(5);

         fimpugVar DATE;

         contador number:=1;

         fechalaudoVar varchar2(10000);

         rd emb_string.string_array;

         fd emb_string.string_array;

         numaactaintVar number;

         fechavalida boolean:=false;

         CURSOR actasConsultar IS

SELECT actas.f_entra_016 AS fechaentrada,

        actas.n_acta_016 AS nacta,

        actas.ano_acta_016 AS anoacta,

        actas.c_territ_016 AS territ,

        centros.rsoc_001 AS razon,

        centros.domic_001 AS domicilio,

        centros.CPOSC_001 AS codigopostal,

        centros.MUNIC_001 AS municipio,

        centros.PROVC_001 AS provincia,

        MAX (impugnaciones.f_impug_033) AS fimpug,              

        NVL(stragg (to_char(laudos.FLAUDO_068,'dd/MM/yyyy')||'|'||laudos.rdo_laudo_068),0) as fechalaudo,

        TO_NUMBER

                         (   actas.c_territ_016

                          || actas.ano_acta_016

                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                     1, '00000' || TO_CHAR (actas.n_acta_016),

                                     2, '0000' || TO_CHAR (actas.n_acta_016),

                                     3, '000' || TO_CHAR (actas.n_acta_016),

                                     4, '00' || TO_CHAR (actas.n_acta_016),

                                     5, '0' || TO_CHAR (actas.n_acta_016),

                                     TO_CHAR (actas.n_acta_016)

                                    )

                         ) AS numaactaint

       FROM w83b16s00 actas,

            w83b33s00 impugnaciones,

            w83b68s00 laudos,

            j7301s01 centros

      WHERE centros.ccen_001 = actas.id_centro_016

        AND actas.n_acta_016 = impugnaciones.n_acta_033

        AND actas.ano_acta_016 = impugnaciones.ano_acta_033

        AND actas.c_territ_016 = impugnaciones.c_territ_033

        AND actas.version_016 = impugnaciones.version_033

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068

        AND impugnaciones.n_impug_033 = laudos.n_impug_068

        AND impugnaciones.c_territ_033 = laudos.c_territ_068

        AND actas.c_territ_016 = territorio

        AND actas.validada_016 = 1

        AND actas.F_BAJA_016 IS NULL

        AND actas.N_ACTTOT_016 IS NULL

       GROUP BY

        actas.f_entra_016,

        actas.n_acta_016,

        actas.ano_acta_016,

        actas.c_territ_016,

        centros.rsoc_001,

        centros.domic_001,

        centros.CPOSC_001,

        centros.MUNIC_001,

        centros.PROVC_001,

        

        TO_NUMBER

                         (   actas.c_territ_016

                          || actas.ano_acta_016

                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                     1, '00000' || TO_CHAR (actas.n_acta_016),

                                     2, '0000' || TO_CHAR (actas.n_acta_016),

                                     3, '000' || TO_CHAR (actas.n_acta_016),

                                     4, '00' || TO_CHAR (actas.n_acta_016),

                                     5, '0' || TO_CHAR (actas.n_acta_016),

                                     TO_CHAR (actas.n_acta_016)

                                    )

                         )

   ORDER BY numaactaint;                          

   BEGIN

       OPEN actasConsultar;     

       LOOP

         FETCH actasConsultar INTO fechaEntradaVar,nactaVar,anoactaVar,

         territVar,razonVar,domicilioVar,codigopostalVar,municipioVar,provinciaVar,fimpugVar,fechalaudoVar,numaactaintVar;

            fechavalida:=false;

            EXIT WHEN actasConsultar%NOTFOUND;

            if (fechalaudoVar!='0') then

                 fd := emb_string.split_string(fechalaudoVar);

                 for i in 1..fd.count loop

                    rd := emb_string.split_string(fd(i),'|');

                    if (rd(2)=1) then

                        if (TO_DATE(rd(1),patron)>=TO_DATE(fechaentrada,patron)) then

                            v_tabla_comimpugresueltas.EXTEND;

                            v_tabla_comimpugresueltas(contador) := comimpugresueltas(nactaVar,

                            anoactaVar,

                            territVar,

                            razonVar,

                            domicilioVar,

                            municipioVar,

                            provinciaVar,

                            '0',

                            codigopostalVar,

                            '0');

                            contador:=contador+1;

                            fechavalida:=true;

                        end if;

                    end if;

                    EXIT WHEN fechavalida = true;

                end loop;

            end if;

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_comimpugresueltas;

   

END w83bcomlaudonegativo;

/



/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION w83bcomlaudosresueltos(territorio IN VARCHAR2)

     RETURN tabla_comimpugresueltas

     IS

         v_tabla_comimpugresueltas tabla_comimpugresueltas := tabla_comimpugresueltas();

         nactaVar NUMBER;

         anoactaVar NUMBER;

         territVar VARCHAR2(50);

         razonVar VARCHAR2(50);

         domicilioVar VARCHAR2(50);

         municipioVar NUMBER;

         provinciaVar NUMBER;

         numactaintVar NUMBER;

         orderbyVar VARCHAR2(1);

         codigopostalVar VARCHAR2(5);

         contador NUMBER:=1;

         nimpugVar VARCHAR2(10000);

         fd emb_string.string_array;

         CURSOR actasConsultar IS

SELECT  actas.n_acta_016 AS nacta,

        actas.ano_acta_016 AS anoacta,

        actas.c_territ_016 AS territ,

        centros.rsoc_001 AS razon,

        centros.domic_001 AS domicilio,

        centros.munic_001 AS municipio,centros.provc_001 AS provincia,  

        stragg (impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||NVL(to_char(laudos.FLAUDO_068,'dd/MM/yyyy'),'0')||'|'||NVL(to_char(impugnaciones.FDESES_033,'dd/MM/yyyy'),'0')) as nimpug,

        TO_NUMBER

                         (   actas.c_territ_016

                          || actas.ano_acta_016

                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                     1, '00000' || TO_CHAR (actas.n_acta_016),

                                     2, '0000' || TO_CHAR (actas.n_acta_016),

                                     3, '000' || TO_CHAR (actas.n_acta_016),

                                     4, '00' || TO_CHAR (actas.n_acta_016),

                                     5, '0' || TO_CHAR (actas.n_acta_016),

                                     TO_CHAR (actas.n_acta_016)

                                    )

                         ) AS numaactaint,

            '1' AS orderby,

            centros.CPOSC_001 as codigopostal

       FROM w83b16s00 actas,

            w83b33s00 impugnaciones,

            w83b68s00 laudos,

            j7301s01 centros

      WHERE centros.ccen_001 = actas.id_centro_016

        AND actas.n_acta_016 = impugnaciones.n_acta_033

        AND actas.ano_acta_016 = impugnaciones.ano_acta_033

        AND actas.c_territ_016 = impugnaciones.c_territ_033

        AND actas.version_016 = impugnaciones.version_033

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND actas.c_territ_016 = territorio

        AND actas.version_016 = 0

        AND actas.validada_016 = 1

        AND actas.F_BAJA_016 IS NULL

        AND actas.N_ACTTOT_016 IS NULL

       GROUP BY

        actas.n_acta_016,

        actas.ano_acta_016,

        actas.c_territ_016,

        centros.rsoc_001,

        centros.domic_001,

        centros.munic_001,

        centros.PROVC_001,

        TO_NUMBER

                         (   actas.c_territ_016

                          || actas.ano_acta_016

                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                     1, '00000' || TO_CHAR (actas.n_acta_016),

                                     2, '0000' || TO_CHAR (actas.n_acta_016),

                                     3, '000' || TO_CHAR (actas.n_acta_016),

                                     4, '00' || TO_CHAR (actas.n_acta_016),

                                     5, '0' || TO_CHAR (actas.n_acta_016),

                                     TO_CHAR (actas.n_acta_016)

                                    )

                         ),

                       '1' ,

                       centros.CPOSC_001 

UNION ALL



SELECT  preavisos.n_preaviso_037 AS nacta,

        preavisos.ano_preaviso_037 AS anoacta,

        preavisos.c_territ_037 AS territ,

        centros.rsoc_001 AS razon,

        centros.domic_001 AS domicilio,

        centros.munic_001 AS municipio,centros.provc_001 AS provincia,         

        stragg (impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||NVL(to_char(laudos.FLAUDO_068,'dd/MM/yyyy'),'0')||'|'||NVL(to_char(impugnaciones.FDESES_033,'dd/MM/yyyy'),'0')) as nimpug,

        TO_NUMBER

                         (   preavisos.c_territ_037

                          || preavisos.ano_preaviso_037

                          || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                                     1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                                     2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                                     3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                                     4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                                     5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                                     TO_CHAR (preavisos.n_preaviso_037)

                                    )

                         ) AS numaactaint,

            '2' AS orderby,

            centros.CPOSC_001 as codigopostal

       FROM w83b37s00 preavisos,

            w83b33s00 impugnaciones,

            w83b68s00 laudos,

            j7301s01 centros

      WHERE centros.ccen_001 = preavisos.id_centro_037

        AND preavisos.n_preaviso_037 = impugnaciones.n_preaviso_033

        AND preavisos.ano_preaviso_037 = impugnaciones.ano_preaviso_033

        AND preavisos.c_territ_037 = impugnaciones.c_territ_033

        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

        AND preavisos.c_territ_037 =territorio

       GROUP BY

        preavisos.n_preaviso_037,

        preavisos.ano_preaviso_037,

        preavisos.c_territ_037,

        centros.rsoc_001,

        centros.domic_001,

        centros.munic_001,

        centros.PROVC_001,

        TO_NUMBER

                         (   preavisos.c_territ_037

                          || preavisos.ano_preaviso_037

                          || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),

                                     1, '00000' || TO_CHAR (preavisos.n_preaviso_037),

                                     2, '0000' || TO_CHAR (preavisos.n_preaviso_037),

                                     3, '000' || TO_CHAR (preavisos.n_preaviso_037),

                                     4, '00' || TO_CHAR (preavisos.n_preaviso_037),

                                     5, '0' || TO_CHAR (preavisos.n_preaviso_037),

                                     TO_CHAR (preavisos.n_preaviso_037)

                                    )

                         ),

                       '2' ,

                       centros.CPOSC_001 

  ORDER BY orderby,numaactaint;            

   BEGIN

       OPEN actasConsultar;     

       LOOP

         FETCH actasConsultar INTO nactaVar,anoactaVar,territVar,razonVar,

         domicilioVar,municipioVar,provinciaVar,nimpugVar,numactaintVar,orderbyVar,codigopostalVar;

            EXIT WHEN actasConsultar%NOTFOUND;

                            v_tabla_comimpugresueltas.EXTEND;

                            v_tabla_comimpugresueltas(contador) := comimpugresueltas(nactaVar,

                            anoactaVar,

                            territVar,

                            razonVar,

                            domicilioVar,

                            municipioVar,

                            provinciaVar,

                            nimpugVar,

                            codigopostalVar,

                            orderbyVar);

                            contador:=contador+1;

                          

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_comimpugresueltas;

   

END w83bcomlaudosresueltos;

/



/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION w83bcomempresas(fechaimpug IN VARCHAR2)

     RETURN tabla_comunicacionempresa

     IS

         v_tabla_comunicacionempresa tabla_comunicacionempresa := tabla_comunicacionempresa(); 

         contador number:=1;

         ver NUMBER;

         fechaentrada DATE;

         nacta NUMBER;

         anoacta NUMBER;

         territ VARCHAR2(2);

         numpreaviso NUMBER;

         anopreaviso NUMBER;

         cif VARCHAR2(10);

         codcentro NUMBER;

         numerocentro NUMBER;

         razon VARCHAR2(50);

         domicilio VARCHAR2(50);

         municipio VARCHAR2(3);

         provincia VARCHAR2(2);

         codigopostal VARCHAR2(5);

         numactaint NUMBER;

         CURSOR actasConsultar IS

SELECT consulta.ver, consulta.fechaentrada,

            consulta.nacta, consulta.anoacta,

            consulta.territ, consulta.numpreaviso,

            consulta.anopreaviso, consulta.cif,

            consulta.codcentro, consulta.numerocentro,

            consulta.razon, consulta.domicilio,

            consulta.municipio, consulta.provincia,

            consulta.codigopostal,

            consulta.numactaint

FROM

(SELECT   actas.version_016 AS ver, actas.f_entra_016 AS fechaentrada,

            actas.n_acta_016 AS nacta, actas.ano_acta_016 AS anoacta,

            actas.c_territ_016 AS territ, actas.n_preaviso_016 AS numpreaviso,

            actas.ano_preaviso_016 AS anopreaviso, centros.ccif_001 AS cif,

            centros.ccen_001 AS codcentro, centros.ncen_001 AS numerocentro,

            centros.rsoc_001 AS razon, centros.domic_001 AS domicilio,

            centros.munic_001 AS municipio, centros.provc_001 AS provincia,

            centros.cposc_001 AS codigopostal,

            TO_NUMBER

                   (   actas.c_territ_016

                    || actas.ano_acta_016

                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                               1, '00000' || TO_CHAR (actas.n_acta_016),

                               2, '0000' || TO_CHAR (actas.n_acta_016),

                               3, '000' || TO_CHAR (actas.n_acta_016),

                               4, '00' || TO_CHAR (actas.n_acta_016),

                               5, '0' || TO_CHAR (actas.n_acta_016),

                               TO_CHAR (actas.n_acta_016)

                              )

                   ) AS numactaint

       FROM w83b16s00 actas, j7301s01 centros

      WHERE centros.ccen_001 = actas.id_centro_016

        AND actas.version_016 = 0

        AND actas.validada_016 = 1

        AND actas.f_baja_016 IS NULL

        AND actas.n_acttot_016 IS NULL) consulta

   where 0 = (select count(*) 

    from

    w83b33s00 impugnaciones inner join w83b68s00 laudos

    on impugnaciones.N_IMPUG_033=laudos.N_IMPUG_068(+)

    and impugnaciones.ANO_IMPUG_033=laudos.ANO_IMPUG_068(+)

    and impugnaciones.C_TERRIT_033=laudos.C_TERRIT_068(+)

    where impugnaciones.ANO_ACTA_033=consulta.anoacta

    and impugnaciones.N_ACTA_033=consulta.nacta

    and impugnaciones.C_TERRIT_033=consulta.territ

    and impugnaciones.VERSION_033=0

    and (laudos.RDO_LAUDO_068=2 or impugnaciones.FDESES_033 is not null)

    and impugnaciones.F_IMPUG_033>=to_date(fechaimpug,'dd/MM/yyyy'))

    order by consulta.numactaint;              

   BEGIN

       OPEN actasConsultar;     

       LOOP

         FETCH actasConsultar INTO ver,fechaentrada,nacta,anoacta,territ,numpreaviso,anopreaviso,cif,codcentro,numerocentro,razon,domicilio,municipio,provincia,codigopostal,numactaint;

            EXIT WHEN actasConsultar%NOTFOUND;

               v_tabla_comunicacionempresa.EXTEND;

               v_tabla_comunicacionempresa(contador) := comunicacionempresa(ver,fechaentrada,nacta,anoacta,territ,numpreaviso,anopreaviso,cif,codcentro,numerocentro,razon,domicilio,municipio,provincia,codigopostal,numactaint);

               contador:=contador+1;

                        

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_comunicacionempresa;

   

END w83bcomempresas;

/





/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION w83bcomempresasfiscal(fechaimpug IN VARCHAR2)

     RETURN tabla_comunicacionempresa

     IS

         v_tabla_comunicacionempresa tabla_comunicacionempresa := tabla_comunicacionempresa(); 

         contador number:=1;

         ver NUMBER;

         fechaentrada DATE;

         nacta NUMBER;

         anoacta NUMBER;

         territ VARCHAR2(2);

         numpreaviso NUMBER;

         anopreaviso NUMBER;

         cif VARCHAR2(10);

         codcentro NUMBER;

         numerocentro NUMBER;

         razon VARCHAR2(50);

         domicilio VARCHAR2(50);

         municipio VARCHAR2(3);

         provincia VARCHAR2(2);

         codigopostal VARCHAR2(5);

         numactaint NUMBER;

         CURSOR actasConsultar IS

SELECT consulta.ver, consulta.fechaentrada,

            consulta.nacta, consulta.anoacta,

            consulta.territ, consulta.numpreaviso,

            consulta.anopreaviso, consulta.cif,

            consulta.codcentro, consulta.numerocentro,

            consulta.razon, consulta.domicilio,

            consulta.municipio, consulta.provincia,

            consulta.codigopostal,

            consulta.numactaint

FROM

(SELECT   actas.version_016 AS ver, actas.f_entra_016 AS fechaentrada,

            actas.n_acta_016 AS nacta, actas.ano_acta_016 AS anoacta,

            actas.c_territ_016 AS territ, actas.n_preaviso_016 AS numpreaviso,

            actas.ano_preaviso_016 AS anopreaviso, centros.ccif_001 AS cif,

            centros.ccen_001 AS codcentro, centros.ncen_001 AS numerocentro,

            centros.rsoc_001 AS razon, centros.domif_001 AS domicilio,

            centros.munif_001 AS municipio, centros.provf_001 AS provincia,

            centros.cposf_001 AS codigopostal,

            TO_NUMBER

                   (   actas.c_territ_016

                    || actas.ano_acta_016

                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                               1, '00000' || TO_CHAR (actas.n_acta_016),

                               2, '0000' || TO_CHAR (actas.n_acta_016),

                               3, '000' || TO_CHAR (actas.n_acta_016),

                               4, '00' || TO_CHAR (actas.n_acta_016),

                               5, '0' || TO_CHAR (actas.n_acta_016),

                               TO_CHAR (actas.n_acta_016)

                              )

                   ) AS numactaint

       FROM w83b16s00 actas, j7301s01 centros

      WHERE centros.ccen_001 = actas.id_centro_016

        AND actas.version_016 = 0

        AND actas.validada_016 = 1

        AND actas.f_baja_016 IS NULL

        AND actas.n_acttot_016 IS NULL) consulta

   where 0 = (select count(*) 

    from

    w83b33s00 impugnaciones inner join w83b68s00 laudos

    on impugnaciones.N_IMPUG_033=laudos.N_IMPUG_068(+)

    and impugnaciones.ANO_IMPUG_033=laudos.ANO_IMPUG_068(+)

    and impugnaciones.C_TERRIT_033=laudos.C_TERRIT_068(+)

    where impugnaciones.ANO_ACTA_033=consulta.anoacta

    and impugnaciones.N_ACTA_033=consulta.nacta

    and impugnaciones.C_TERRIT_033=consulta.territ

    and impugnaciones.VERSION_033=0

    and (laudos.RDO_LAUDO_068=2 or impugnaciones.FDESES_033 is not null)

    and impugnaciones.F_IMPUG_033>=to_date(fechaimpug,'dd/MM/yyyy'))

    order by consulta.numactaint;              

   BEGIN

       OPEN actasConsultar;     

       LOOP

         FETCH actasConsultar INTO ver,fechaentrada,nacta,anoacta,territ,numpreaviso,anopreaviso,cif,codcentro,numerocentro,razon,domicilio,municipio,provincia,codigopostal,numactaint;

            EXIT WHEN actasConsultar%NOTFOUND;

               v_tabla_comunicacionempresa.EXTEND;

               v_tabla_comunicacionempresa(contador) := comunicacionempresa(ver,fechaentrada,nacta,anoacta,territ,numpreaviso,anopreaviso,cif,codcentro,numerocentro,razon,domicilio,municipio,provincia,codigopostal,numactaint);

               contador:=contador+1;

                        

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_comunicacionempresa;

   

END w83bcomempresasfiscal;

/



/* **************************************************************************************************** */

CREATE OR REPLACE FUNCTION W83BCOMEXTRACCIONDATOS(sindicato NUMBER, tipovoz NUMBER, voz NUMBER, sino NUMBER)

     RETURN tabla_COMEXTRACCIONDATOS

     IS

         v_tabla_COMEXTRACCIONDATOS tabla_COMEXTRACCIONDATOS := tabla_COMEXTRACCIONDATOS();

         nacta NUMBER;

         anoacta NUMBER;

         territ VARCHAR2(2);

         nimpug NUMBER;

         anoimpug NUMBER;

         nlaudo NUMBER;

         anolaudo NUMBER;

         flaudo DATE;

         arbitro VARCHAR2(250);

         cif VARCHAR2(10);

         razonsocial VARCHAR2(50);

         sindicatos VARCHAR2(5000);

         voces VARCHAR2(5000);

         orderbyvar VARCHAR2(1);

         contador NUMBER:=1;

         valido boolean:=false;

         sind emb_string.string_array;

         s emb_string.string_array;

         vo emb_string.string_array;

         v emb_string.string_array;

       CURSOR actasConsultar IS

/* Formatted on 2012/05/22 12:33 (Formatter Plus v4.8.8) */

SELECT   consulta.nacta, consulta.anoacta, consulta.territ, consulta.nimpug,

         consulta.anoimpug, consulta.nlaudo, consulta.anolaudo,

         consulta.flaudo, consulta.arbitro, consulta.cif,

         consulta.razonsocial, consulta.sindicatos, consulta.orderby,

         (SELECT CASE

                    WHEN (stragg_int (vocesimpug.ctipvoz_034) IS NOT NULL)

                       THEN stragg_int (   vocesimpug.ctipvoz_034

                                        || '|'

                                        || vocesimpug.cvoz_034

                                        || '|'

                                        || vocesimpug.sino_034

                                        || '|'

                                        || voces.desc_031

                                        || '|'

                                        || voces.dese_031

                                       )

                    ELSE ''

                 END

            FROM w83b34s00 vocesimpug, w83b31s00 voces

           WHERE consulta.nimpug = vocesimpug.n_impug_034

             AND consulta.anoimpug = vocesimpug.ano_impug_034

             AND consulta.nlaudo = vocesimpug.n_laudo_034

             AND consulta.anolaudo = vocesimpug.ano_laudo_034

             AND consulta.territ = vocesimpug.c_territ_034

             AND vocesimpug.cvoz_034 = voces.cvoz_031

             AND vocesimpug.ctipvoz_034 = voces.ctipvoz_031)

    FROM (SELECT   preavisos.n_preaviso_037 AS nacta,

                   preavisos.ano_preaviso_037 AS anoacta,

                   preavisos.c_territ_037 AS territ,

                   impugnaciones.n_impug_033 AS nimpug,

                   impugnaciones.ano_impug_033 AS anoimpug,

                   laudos.n_laudo_068 AS nlaudo,

                   laudos.ano_laudo_068 AS anolaudo,

                   laudos.flaudo_068 AS flaudo,

                   arbitros.nombre_036 AS arbitro, centros.ccif_001 AS cif,

                   centros.rsoc_001 AS razonsocial,

                   CASE

                      WHEN (stragg_int (sindimp.c_sindi_035) IS NOT NULL

                           )

                         THEN stragg_int (   sindimp.c_sindi_035

                                          || '|'

                                          || sindicatos.siglas_019

                                         )

                      ELSE ''

                   END AS sindicatos,

                   '2' AS orderby                                            --,

--CASE WHEN(STRAGG_INT(TIPOVOCES.CTIPVOZ_032) IS NOT NULL) THEN STRAGG_INT(TIPOVOCES.CTIPVOZ_032) ELSE '' END

          FROM     w83b37s00 preavisos,

                   j7301s01 centros,

                   w83b33s00 impugnaciones,

                   w83b36s00 arbitros,

                   w83b35s00 sindimp,

                   w83b19s00 sindicatos,

                   w83b68s00 laudos

                   --,W83B34S00 VOCESIMPUG,W83B31S00 VOCES,W83B32S00 TIPOVOCES

             WHERE centros.ccen_001 = preavisos.id_centro_037

               AND preavisos.n_preaviso_037 = impugnaciones.n_preaviso_033

               AND preavisos.ano_preaviso_037 = impugnaciones.ano_preaviso_033

               AND preavisos.c_territ_037 = impugnaciones.c_territ_033

               AND impugnaciones.dni_033 = arbitros.dni_036(+)

               AND impugnaciones.n_impug_033 = sindimp.n_impug_035(+)

               AND impugnaciones.ano_impug_033 = sindimp.ano_impug_035(+)

               AND impugnaciones.c_territ_033 = sindimp.c_territ_035(+)

               AND sindimp.c_sindi_035 = sindicatos.c_sindi_019(+)

               AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

               AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

               AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

--AND VOCES.CTIPVOZ_031=TIPOVOCES.CTIPVOZ_032

          GROUP BY preavisos.n_preaviso_037,

                   preavisos.ano_preaviso_037,

                   preavisos.c_territ_037,

                   impugnaciones.n_impug_033,

                   impugnaciones.ano_impug_033,

                   laudos.n_laudo_068,

                   laudos.ano_laudo_068,

                   laudos.flaudo_068,

                   arbitros.nombre_036,

                   centros.ccif_001,

                   centros.rsoc_001,

                   '2') consulta

UNION ALL

SELECT   consulta.nacta, consulta.anoacta, consulta.territ, consulta.nimpug,

         consulta.anoimpug, consulta.nlaudo, consulta.anolaudo,

         consulta.flaudo, consulta.arbitro, consulta.cif,

         consulta.razonsocial, consulta.sindicatos, consulta.orderby,

         (SELECT CASE

                    WHEN (stragg_int (vocesimpug.ctipvoz_034) IS NOT NULL)

                       THEN stragg_int (   vocesimpug.ctipvoz_034

                                        || '|'

                                        || vocesimpug.cvoz_034

                                        || '|'

                                        || vocesimpug.sino_034

                                        || '|'

                                        || voces.desc_031

                                        || '|'

                                        || voces.dese_031

                                       )

                    ELSE ''

                 END

            FROM w83b34s00 vocesimpug, w83b31s00 voces

           WHERE consulta.nimpug = vocesimpug.n_impug_034

             AND consulta.anoimpug = vocesimpug.ano_impug_034

             AND consulta.nlaudo = vocesimpug.n_laudo_034

             AND consulta.anolaudo = vocesimpug.ano_laudo_034

             AND consulta.territ = vocesimpug.c_territ_034

             AND vocesimpug.cvoz_034 = voces.cvoz_031

             AND vocesimpug.ctipvoz_034 = voces.ctipvoz_031)

    FROM (SELECT   actas.n_acta_016 AS nacta, actas.ano_acta_016 anoacta,

                   actas.c_territ_016 AS territ,

                   impugnaciones.n_impug_033 AS nimpug,

                   impugnaciones.ano_impug_033 AS anoimpug,

                   laudos.n_laudo_068 AS nlaudo,

                   laudos.ano_laudo_068 AS anolaudo,

                   laudos.flaudo_068 AS flaudo,

                   arbitros.nombre_036 AS arbitro, centros.ccif_001 AS cif,

                   centros.rsoc_001 AS razonsocial,

                   CASE

                      WHEN (stragg_int (sindimp.c_sindi_035) IS NOT NULL

                           )

                         THEN stragg_int (   sindimp.c_sindi_035

                                          || '|'

                                          || sindicatos.siglas_019

                                         )

                      ELSE ''

                   END AS sindicatos,

                   '1' AS orderby                                            --,

--CASE WHEN(STRAGG_INT(TIPOVOCES.CTIPVOZ_032) IS NOT NULL) THEN STRAGG_INT(TIPOVOCES.CTIPVOZ_032) ELSE '' END

          FROM     w83b16s00 actas,

                   j7301s01 centros,

                   w83b33s00 impugnaciones,

                   w83b36s00 arbitros,

                   w83b35s00 sindimp,

                   w83b19s00 sindicatos,

                   w83b68s00 laudos

                   --,W83B34S00 VOCESIMPUG,W83B31S00 VOCES,W83B32S00 TIPOVOCES

             WHERE centros.ccen_001 = actas.id_centro_016

               AND actas.n_acta_016 = impugnaciones.n_acta_033

               AND actas.ano_acta_016 = impugnaciones.ano_acta_033

               AND actas.c_territ_016 = impugnaciones.c_territ_033

               AND actas.version_016 = impugnaciones.version_033

               AND impugnaciones.dni_033 = arbitros.dni_036(+)

               AND impugnaciones.n_impug_033 = sindimp.n_impug_035(+)

               AND impugnaciones.ano_impug_033 = sindimp.ano_impug_035(+)

               AND impugnaciones.c_territ_033 = sindimp.c_territ_035(+)

               AND sindimp.c_sindi_035 = sindicatos.c_sindi_019(+)

               AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)

               AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)

               AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)

--AND VOCES.CTIPVOZ_031=TIPOVOCES.CTIPVOZ_032

               AND actas.version_016 = 0

               AND actas.validada_016 = 1

               AND actas.f_baja_016 IS NULL

               AND actas.n_acttot_016 IS NULL

          GROUP BY actas.n_acta_016,

                   actas.ano_acta_016,

                   actas.c_territ_016,

                   impugnaciones.n_impug_033,

                   impugnaciones.ano_impug_033,

                   laudos.n_laudo_068,

                   laudos.ano_laudo_068,

                   laudos.flaudo_068,

                   arbitros.nombre_036,

                   centros.ccif_001,

                   centros.rsoc_001,

                   '1') consulta

ORDER BY nlaudo, anolaudo, territ, orderby;



   BEGIN

       OPEN actasConsultar;

       LOOP

         FETCH actasConsultar INTO  nacta,anoacta,territ,nimpug,anoimpug,nlaudo,anolaudo,flaudo,arbitro,cif,razonsocial,sindicatos,orderbyvar,voces;

            EXIT WHEN actasConsultar%NOTFOUND;

            if (sindicato=-1 AND voz=-1 AND tipovoz=-1) then

                valido:=true;

            else

                if (sindicato!=-1) then

                    valido:=false;

                    sind := emb_string.split_string(sindicatos,'?');

                    for i in 1..sind.count loop

                        s := emb_string.split_string(sind(i),'|');

                        if (s(1)=sindicato) then

                            valido:=true;

                        end if;

                    exit when valido = true;

                    end loop;

                end if;

                if (tipovoz!=-1 AND voz!=-1) then

                    valido:=false;

                    vo := emb_string.split_string(voces,'?');

                    for j in 1..vo.count loop

                        v := emb_string.split_string(vo(j),'|');

                        if (v(1)=tipovoz AND v(2)=voz AND v(3)=sino) then

                            valido:=true;

                        end if;

                        exit when valido = true;

                    end loop;

                else if ( tipovoz!=-1 AND voz=-1) then

                    valido:=false;

                    vo := emb_string.split_string(voces,'?');

                    for h in 1..vo.count loop

                        v := emb_string.split_string(vo(h),'|');

                        if (v(1)=tipovoz) then

                            valido:=true;

                        end if;

                        exit when valido = true;

                    end loop;

                end if;

             end if; 

            end if;

            if (valido) then

                 v_tabla_COMEXTRACCIONDATOS.EXTEND;

                            v_tabla_COMEXTRACCIONDATOS(contador) := COMEXTRACCIONDATOS(nacta,anoacta,territ,nimpug,anoimpug,nlaudo,anolaudo,flaudo,arbitro,cif,razonsocial,sindicatos,voces,orderbyvar);

                            contador:=contador+1;

                end if;               

        END LOOP;

        CLOSE actasConsultar;

   RETURN v_tabla_COMEXTRACCIONDATOS;



END W83BCOMEXTRACCIONDATOS;

/







COMMIT;

